/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpj;

import java.util.List;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.Validador;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class RendPJTitular
extends ObjetoNegocio {
    public static final String NOME_NI_FONTE_PAGADORA = "NI da Fonte Pagadora";
    public static final String NOME_REND_RECEB_PJ = "Rend. Recebid";
    public static final String NOME_CONTRIB_PREV = "Contr. Prev. Oficial";
    public static final String NOME_IMPOSTO_RETIDO = "IR Retido na Fonte";
    public static final String NOME_DECIMO_TERCEIRO = "13\u00ba Sal\u00e1rio";
    protected transient IdentificadorDeclaracao identificadorDeclaracao = null;
    protected Alfa nomeFontePagadora = new Alfa(this, "Nome da Fonte Pagadora");
    protected NI NIFontePagadora = new NI(this, "NI da Fonte Pagadora");
    protected Valor rendRecebidoPJ = new Valor(this, "Rend. Recebid");
    protected Valor contribuicaoPrevOficial = new Valor(this, "Contr. Prev. Oficial");
    protected Valor impostoRetidoFonte = new Valor(this, "IR Retido na Fonte");
    protected Valor decimoTerceiro = new Valor(this, "13\u00ba Sal\u00e1rio");

    public RendPJTitular(IdentificadorDeclaracao identificadorDeclaracao) {
        this.identificadorDeclaracao = identificadorDeclaracao;
        this.addValidadores();
    }

    public void addValidadores() {
        ValidadorNaoNulo validadorNaoNulo = new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                RetornoValidacao retornoValidacao = Validador.validarNI(RendPJTitular.this.getNIFontePagadora().asString());
                if (retornoValidacao == null && RendPJTitular.this.getNomeFontePagadora().isVazio()) {
                    this.setSeveridade((byte)2);
                    return new RetornoValidacao(tab.msg("nome_fonte_pagadora_ausente"), 2);
                }
                if (retornoValidacao != null && RendPJTitular.this.getNomeFontePagadora().isVazio()) {
                    this.setSeveridade((byte)3);
                    return new RetornoValidacao(tab.msg("nome_fonte_pagadora"), 3);
                }
                return null;
            }
        };
        this.getNomeFontePagadora().addValidador(validadorNaoNulo);
        ValidadorNaoNulo validadorNaoNulo2 = new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                RetornoValidacao retornoValidacao = Validador.validarNI(RendPJTitular.this.getNIFontePagadora().asString());
                if (RendPJTitular.this.getNIFontePagadora().asString().equals(RendPJTitular.this.identificadorDeclaracao.getCpf().asString())) {
                    this.setSeveridade((byte)3);
                    return new RetornoValidacao(tab.msg("ni_fonte_pagadora_igual_declarante"), 3);
                }
                if (retornoValidacao != null && !RendPJTitular.this.getImpostoRetidoFonte().isVazio()) {
                    this.setSeveridade((byte)3);
                    return new RetornoValidacao(tab.msg("ni_fonte_pagadora"), 3);
                }
                if (retornoValidacao != null && RendPJTitular.this.getImpostoRetidoFonte().isVazio()) {
                    this.setSeveridade((byte)2);
                    return new RetornoValidacao(tab.msg("ni_fonte_pagadora"), 2);
                }
                return null;
            }
        };
        this.getNIFontePagadora().addValidador(validadorNaoNulo2);
    }

    public void addObservador(Observador observador) {
        this.rendRecebidoPJ.addObservador(observador);
        this.contribuicaoPrevOficial.addObservador(observador);
        this.impostoRetidoFonte.addObservador(observador);
        this.decimoTerceiro.addObservador(observador);
        this.NIFontePagadora.addObservador(observador);
    }

    public void removeObservador(Observador observador) {
        this.rendRecebidoPJ.removeObservador(observador);
        this.contribuicaoPrevOficial.removeObservador(observador);
        this.impostoRetidoFonte.removeObservador(observador);
        this.decimoTerceiro.removeObservador(observador);
        this.NIFontePagadora.removeObservador(observador);
    }

    public Valor getContribuicaoPrevOficial() {
        return this.contribuicaoPrevOficial;
    }

    public Valor getDecimoTerceiro() {
        return this.decimoTerceiro;
    }

    public Valor getImpostoRetidoFonte() {
        return this.impostoRetidoFonte;
    }

    public NI getNIFontePagadora() {
        return this.NIFontePagadora;
    }

    public Alfa getNomeFontePagadora() {
        return this.nomeFontePagadora;
    }

    public Valor getRendRecebidoPJ() {
        return this.rendRecebidoPJ;
    }

    public Pendencia verificaValores(int n) {
        Pendencia pendencia = null;
        if (this.getImpostoRetidoFonte().isVazio() && this.getContribuicaoPrevOficial().isVazio() && this.getDecimoTerceiro().isVazio() && this.getRendRecebidoPJ().isVazio()) {
            pendencia = new Pendencia(2, this.getRendRecebidoPJ(), "Valores RendPJ", this.tab.msg("rendpj_faltam_valores"), n);
        }
        return pendencia;
    }

    public List verificarPendencias(int n) {
        List list = super.verificarPendencias(n);
        Pendencia pendencia = this.verificaValores(n);
        if (pendencia != null) {
            list.add(pendencia);
        }
        return list;
    }

    protected List recuperarListaCamposPendencia() {
        List list = this.recuperarCamposInformacao();
        return list;
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio()) continue;
            return false;
        }
        return true;
    }
}

