/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import org.jfree.data.DataUtilities;
import org.jfree.data.category.CategoryDataset;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public abstract class AbstractCategoryItemLabelGenerator
implements PublicCloneable,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7108591260223293197L;
    private String labelFormat;
    private String nullValueString;
    private NumberFormat numberFormat;
    private DateFormat dateFormat;
    private NumberFormat percentFormat;

    protected AbstractCategoryItemLabelGenerator(String string, NumberFormat numberFormat) {
        this(string, numberFormat, NumberFormat.getPercentInstance());
    }

    protected AbstractCategoryItemLabelGenerator(String string, NumberFormat numberFormat, NumberFormat numberFormat2) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'labelFormat' argument.");
        }
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null 'formatter' argument.");
        }
        if (numberFormat2 == null) {
            throw new IllegalArgumentException("Null 'percentFormatter' argument.");
        }
        this.labelFormat = string;
        this.numberFormat = numberFormat;
        this.percentFormat = numberFormat2;
        this.dateFormat = null;
        this.nullValueString = "-";
    }

    protected AbstractCategoryItemLabelGenerator(String string, DateFormat dateFormat) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'labelFormat' argument.");
        }
        if (dateFormat == null) {
            throw new IllegalArgumentException("Null 'formatter' argument.");
        }
        this.labelFormat = string;
        this.numberFormat = null;
        this.percentFormat = NumberFormat.getPercentInstance();
        this.dateFormat = dateFormat;
        this.nullValueString = "-";
    }

    public String generateRowLabel(CategoryDataset categoryDataset, int n) {
        return categoryDataset.getRowKey(n).toString();
    }

    public String generateColumnLabel(CategoryDataset categoryDataset, int n) {
        return categoryDataset.getColumnKey(n).toString();
    }

    public String getLabelFormat() {
        return this.labelFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    protected String generateLabelString(CategoryDataset categoryDataset, int n, int n2) {
        if (categoryDataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        String string = null;
        Object[] objectArray = this.createItemArray(categoryDataset, n, n2);
        string = MessageFormat.format(this.labelFormat, objectArray);
        return string;
    }

    protected Object[] createItemArray(CategoryDataset categoryDataset, int n, int n2) {
        Object[] objectArray = new Object[4];
        objectArray[0] = categoryDataset.getRowKey(n).toString();
        objectArray[1] = categoryDataset.getColumnKey(n2).toString();
        Number number = categoryDataset.getValue(n, n2);
        if (number != null) {
            if (this.numberFormat != null) {
                objectArray[2] = this.numberFormat.format(number);
            } else if (this.dateFormat != null) {
                objectArray[2] = this.dateFormat.format(number);
            }
        } else {
            objectArray[2] = this.nullValueString;
        }
        if (number != null) {
            double d = DataUtilities.calculateColumnTotal(categoryDataset, n2);
            double d2 = number.doubleValue() / d;
            objectArray[3] = this.percentFormat.format(d2);
        }
        return objectArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractCategoryItemLabelGenerator)) {
            return false;
        }
        AbstractCategoryItemLabelGenerator abstractCategoryItemLabelGenerator = (AbstractCategoryItemLabelGenerator)object;
        if (!this.labelFormat.equals(abstractCategoryItemLabelGenerator.labelFormat)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.dateFormat, abstractCategoryItemLabelGenerator.dateFormat)) {
            return false;
        }
        return ObjectUtilities.equal(this.numberFormat, abstractCategoryItemLabelGenerator.numberFormat);
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractCategoryItemLabelGenerator abstractCategoryItemLabelGenerator = (AbstractCategoryItemLabelGenerator)super.clone();
        if (this.numberFormat != null) {
            abstractCategoryItemLabelGenerator.numberFormat = (NumberFormat)this.numberFormat.clone();
        }
        if (this.dateFormat != null) {
            abstractCategoryItemLabelGenerator.dateFormat = (DateFormat)this.dateFormat.clone();
        }
        return abstractCategoryItemLabelGenerator;
    }
}

