/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.CharConstant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;

public class CharLiteral
extends NumberLiteral {
    char value;

    public CharLiteral(char[] cArray, int n, int n2) {
        super(cArray, n, n2);
        this.computeValue();
    }

    public void computeConstant() {
        this.constant = CharConstant.fromValue(this.value);
    }

    private void computeValue() {
        this.value = this.source[1];
        if (this.value != '\\') {
            return;
        }
        char c = this.source[2];
        switch (c) {
            case 'b': {
                this.value = (char)8;
                break;
            }
            case 't': {
                this.value = (char)9;
                break;
            }
            case 'n': {
                this.value = (char)10;
                break;
            }
            case 'f': {
                this.value = (char)12;
                break;
            }
            case 'r': {
                this.value = (char)13;
                break;
            }
            case '\"': {
                this.value = (char)34;
                break;
            }
            case '\'': {
                this.value = (char)39;
                break;
            }
            case '\\': {
                this.value = (char)92;
                break;
            }
            default: {
                int n = ScannerHelper.getNumericValue(c);
                c = this.source[3];
                if (c == '\'') {
                    this.value = (char)n;
                    this.constant = CharConstant.fromValue(this.value);
                    break;
                }
                n = n * 8 + ScannerHelper.getNumericValue(c);
                c = this.source[4];
                if (c != '\'') {
                    n = n * 8 + ScannerHelper.getNumericValue(c);
                }
                this.value = (char)n;
            }
        }
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (bl) {
            codeStream.generateConstant(this.constant, this.implicitConversion);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public TypeBinding literalType(BlockScope blockScope) {
        return TypeBinding.CHAR;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }
}

