/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import serpro.ppgd.gui.ConstantesGlobaisGUI;
import serpro.ppgd.gui.EditCampo;
import serpro.ppgd.gui.FabricaGUI;
import serpro.ppgd.negocio.Informacao;

public class ContainerPPGD
extends Box {
    public static final byte NONE = 0;
    public static final byte ESQUERDA = 1;
    public static final byte ACIMA = 2;
    private float alinhamento;
    private int eixo;
    private byte posicaoRotulo;

    public ContainerPPGD() {
        super(1);
        this.eixo = 1;
        this.alinhamento = 0.0f;
        this.posicaoRotulo = 1;
    }

    public ContainerPPGD(int n, float f, byte by) {
        super(n);
        this.eixo = n;
        this.alinhamento = f;
        if (by < 0 || by > 2) {
            throw new IllegalArgumentException("Posi\u00e7\u00e3o do r\u00f3tulo inv\u00e1lida");
        }
        this.posicaoRotulo = by;
    }

    public void addTitulo(String string, float f) {
        JLabel jLabel = new JLabel(string);
        jLabel.setText(string);
        this.configuraAlinhamento(jLabel, f);
        this.add(jLabel);
    }

    public EditCampo addCampo(EditCampo editCampo) {
        return this.addCampo(editCampo, null);
    }

    public EditCampo addCampo(EditCampo editCampo, String string) {
        editCampo.setIdAjuda(string);
        this.adicionaCampo(editCampo);
        return editCampo;
    }

    public EditCampo addCampo(Informacao informacao) {
        return this.addCampo(informacao, (String)null);
    }

    public EditCampo addCampo(Informacao informacao, String string) {
        Dimension[] dimensionArray = new Dimension[]{new Dimension(0, 0)};
        return this.addCampo(informacao, dimensionArray, string);
    }

    public EditCampo addCampo(Informacao informacao, int n) {
        return this.addCampo(informacao, n, null);
    }

    public EditCampo addCampo(Informacao informacao, int n, String string) {
        Dimension[] dimensionArray = new Dimension[]{new Dimension(n, 0)};
        return this.addCampo(informacao, dimensionArray, string);
    }

    public EditCampo addCampo(Informacao informacao, Dimension dimension, String string) {
        Dimension[] dimensionArray = new Dimension[]{dimension};
        return this.addCampo(informacao, dimensionArray, string);
    }

    public EditCampo addCampo(Informacao informacao, Dimension[] dimensionArray) {
        return this.addCampo(informacao, dimensionArray, null);
    }

    public EditCampo addCampo(Informacao informacao, Dimension[] dimensionArray, String string) {
        EditCampo editCampo = FabricaGUI.getEditorInformacao(informacao, dimensionArray, string);
        this.adicionaCampo(editCampo);
        return editCampo;
    }

    private void adicionaCampo(EditCampo editCampo) {
        this.configuraAlinhamento(this, this.alinhamento);
        JComponent jComponent = FabricaGUI.criaJCampo(editCampo);
        this.configuraAlinhamento(jComponent, this.alinhamento);
        if (this.eixo == 1) {
            switch (this.posicaoRotulo) {
                case 2: {
                    this.add(Box.createRigidArea(ConstantesGlobaisGUI.VGAP5));
                    this.configuraAlinhamento(editCampo.getRotulo(), this.alinhamento);
                    this.add(editCampo.getRotulo());
                    this.add(jComponent);
                    break;
                }
                case 1: {
                    this.add(Box.createRigidArea(ConstantesGlobaisGUI.VGAP5));
                    ContainerPPGD containerPPGD = new ContainerPPGD(0, 0.0f, 0);
                    containerPPGD.configuraAlinhamento(editCampo.getRotulo(), 0.5f);
                    this.configuraAlinhamento(containerPPGD, 0.0f);
                    containerPPGD.add(Box.createRigidArea(ConstantesGlobaisGUI.HGAP5));
                    containerPPGD.add(editCampo.getRotulo());
                    containerPPGD.add(Box.createRigidArea(ConstantesGlobaisGUI.HGAP5));
                    containerPPGD.add(jComponent);
                    this.add(containerPPGD);
                    break;
                }
                default: {
                    this.add(Box.createRigidArea(ConstantesGlobaisGUI.VGAP5));
                    this.add(jComponent);
                    break;
                }
            }
        } else if (this.eixo == 0) {
            switch (this.posicaoRotulo) {
                case 2: {
                    ContainerPPGD containerPPGD = new ContainerPPGD(1, 0.0f, 2);
                    containerPPGD.configuraAlinhamento(editCampo.getRotulo(), this.alinhamento);
                    containerPPGD.configuraAlinhamento(jComponent, this.alinhamento);
                    containerPPGD.add(editCampo.getRotulo());
                    containerPPGD.add(jComponent);
                    this.add(containerPPGD);
                    this.add(Box.createRigidArea(ConstantesGlobaisGUI.HGAP10));
                    break;
                }
                case 1: {
                    this.configuraAlinhamento(editCampo.getRotulo(), this.alinhamento);
                    this.configuraAlinhamento(jComponent, this.alinhamento);
                    this.add(editCampo.getRotulo());
                    this.add(jComponent);
                    this.add(Box.createRigidArea(ConstantesGlobaisGUI.HGAP10));
                    break;
                }
                default: {
                    this.add(jComponent);
                }
            }
        }
    }

    public void addBox(ContainerPPGD containerPPGD) {
        this.configuraAlinhamento(containerPPGD, this.alinhamento);
        this.add(Box.createRigidArea(ConstantesGlobaisGUI.VGAP5));
        this.add(containerPPGD);
    }

    private void configuraAlinhamento(JComponent jComponent, float f) {
        if (this.eixo == 1) {
            jComponent.setAlignmentX(f);
            jComponent.setAlignmentY(0.5f);
        } else if (this.eixo == 0) {
            jComponent.setAlignmentX(0.5f);
            jComponent.setAlignmentY(f);
        }
    }
}

