/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.awt.Shape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.io.SerialUtilities;
import org.jfree.util.AbstractObjectList;

public class ShapeList
extends AbstractObjectList {
    public Shape getShape(int n) {
        return (Shape)this.get(n);
    }

    public void setShape(int n, Shape shape) {
        this.set(n, shape);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof ShapeList) {
            return super.equals(object);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.size();
        objectOutputStream.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            Shape shape = this.getShape(n2);
            if (shape != null) {
                objectOutputStream.writeInt(n2);
                SerialUtilities.writeShape(shape, objectOutputStream);
            } else {
                objectOutputStream.writeInt(-1);
            }
            ++n2;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            int n3 = objectInputStream.readInt();
            if (n3 != -1) {
                this.setShape(n3, SerialUtilities.readShape(objectInputStream));
            }
            ++n2;
        }
    }
}

