/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base.modules;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.jfree.base.AbstractBoot;
import org.jfree.base.config.HierarchicalConfiguration;
import org.jfree.base.config.PropertyFileConfiguration;
import org.jfree.base.log.PadMessage;
import org.jfree.base.modules.DefaultModuleInfo;
import org.jfree.base.modules.Module;
import org.jfree.base.modules.ModuleInfo;
import org.jfree.base.modules.PackageSorter;
import org.jfree.base.modules.PackageState;
import org.jfree.util.Configuration;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public final class PackageManager {
    private static final int RETURN_MODULE_LOADED = 0;
    private static final int RETURN_MODULE_UNKNOWN = 1;
    private static final int RETURN_MODULE_ERROR = 2;
    private final PackageConfiguration packageConfiguration;
    private final ArrayList modules;
    private final ArrayList initSections;
    private AbstractBoot booter;
    private static HashMap instances;

    public static PackageManager createInstance(AbstractBoot abstractBoot) {
        if (instances == null) {
            instances = new HashMap();
            PackageManager packageManager = new PackageManager(abstractBoot);
            instances.put(abstractBoot, packageManager);
            return packageManager;
        }
        PackageManager packageManager = (PackageManager)instances.get(abstractBoot);
        if (packageManager == null) {
            packageManager = new PackageManager(abstractBoot);
            instances.put(abstractBoot, packageManager);
        }
        return packageManager;
    }

    private PackageManager(AbstractBoot abstractBoot) {
        if (abstractBoot == null) {
            throw new NullPointerException();
        }
        this.booter = abstractBoot;
        this.packageConfiguration = new PackageConfiguration();
        this.modules = new ArrayList();
        this.initSections = new ArrayList();
    }

    public boolean isModuleAvailable(ModuleInfo moduleInfo) {
        PackageState[] packageStateArray = this.modules.toArray(new PackageState[this.modules.size()]);
        int n = 0;
        while (n < packageStateArray.length) {
            PackageState packageState = packageStateArray[n];
            if (packageState.getModule().getModuleClass().equals(moduleInfo.getModuleClass())) {
                return packageState.getState() == 2;
            }
            ++n;
        }
        return false;
    }

    public void load(String string) {
        if (this.initSections.contains(string)) {
            return;
        }
        this.initSections.add(string);
        Configuration configuration = this.booter.getGlobalConfig();
        Iterator iterator = configuration.findPropertyKeys(string);
        int n = 0;
        while (iterator.hasNext()) {
            String string2;
            String string3 = (String)iterator.next();
            if (!string3.endsWith(".Module") || (string2 = configuration.getConfigProperty(string3)) == null || string2.length() <= 0) continue;
            this.addModule(string2);
            ++n;
        }
        Log.debug("Loaded a total of " + n + " modules under prefix: " + string);
    }

    public synchronized void initializeModules() {
        PackageState packageState;
        PackageSorter.sort(this.modules);
        int n = 0;
        while (n < this.modules.size()) {
            packageState = (PackageState)this.modules.get(n);
            if (packageState.configure(this.booter)) {
                Log.debug(new Log.SimpleMessage("Conf: ", new PadMessage(packageState.getModule().getModuleClass(), 70), " [", packageState.getModule().getSubSystem(), "]"));
            }
            ++n;
        }
        n = 0;
        while (n < this.modules.size()) {
            packageState = (PackageState)this.modules.get(n);
            if (packageState.initialize(this.booter)) {
                Log.debug(new Log.SimpleMessage("Init: ", new PadMessage(packageState.getModule().getModuleClass(), 70), " [", packageState.getModule().getSubSystem(), "]"));
            }
            ++n;
        }
    }

    public synchronized void addModule(String string) {
        DefaultModuleInfo defaultModuleInfo = new DefaultModuleInfo(string, null, null, null);
        ArrayList arrayList = new ArrayList();
        if (this.loadModule(defaultModuleInfo, new ArrayList(), arrayList, false)) {
            int n = 0;
            while (n < arrayList.size()) {
                Module module = (Module)arrayList.get(n);
                this.modules.add(new PackageState(module));
                ++n;
            }
        }
    }

    private int containsModule(ArrayList arrayList, ModuleInfo moduleInfo) {
        int n;
        Object[] objectArray;
        if (arrayList != null) {
            objectArray = arrayList.toArray(new ModuleInfo[arrayList.size()]);
            n = 0;
            while (n < objectArray.length) {
                if (objectArray[n].getModuleClass().equals(moduleInfo.getModuleClass())) {
                    return 0;
                }
                ++n;
            }
        }
        objectArray = this.modules.toArray(new PackageState[this.modules.size()]);
        n = 0;
        while (n < objectArray.length) {
            if (((PackageState)objectArray[n]).getModule().getModuleClass().equals(moduleInfo.getModuleClass())) {
                if (((PackageState)objectArray[n]).getState() == -2) {
                    return 2;
                }
                return 0;
            }
            ++n;
        }
        return 1;
    }

    private void dropFailedModule(PackageState packageState) {
        if (!this.modules.contains(packageState)) {
            this.modules.add(packageState);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadModule(ModuleInfo moduleInfo, ArrayList arrayList, ArrayList arrayList2, boolean bl) {
        try {
            Class<?> clazz = ObjectUtilities.getClassLoader(this.getClass()).loadClass(moduleInfo.getModuleClass());
            Module module = (Module)clazz.newInstance();
            if (!this.acceptVersion(moduleInfo, module)) {
                Log.warn("Module " + module.getName() + ": required version: " + moduleInfo + ", but found Version: \n" + module);
                PackageState packageState = new PackageState(module, -2);
                this.dropFailedModule(packageState);
                return false;
            }
            int n = this.containsModule(arrayList2, module);
            if (n == 2) {
                Log.debug("Indicated failure for module: " + module.getModuleClass());
                PackageState packageState = new PackageState(module, -2);
                this.dropFailedModule(packageState);
                return false;
            }
            if (n == 1) {
                if (arrayList.contains(module)) {
                    Log.error(new Log.SimpleMessage("Circular module reference: This module definition is invalid: ", module.getClass()));
                    PackageState packageState = new PackageState(module, -2);
                    this.dropFailedModule(packageState);
                    return false;
                }
                arrayList.add(module);
                ModuleInfo[] moduleInfoArray = module.getRequiredModules();
                int n2 = 0;
                while (n2 < moduleInfoArray.length) {
                    if (!this.loadModule(moduleInfoArray[n2], arrayList, arrayList2, true)) {
                        Log.debug("Indicated failure for module: " + module.getModuleClass());
                        PackageState packageState = new PackageState(module, -2);
                        this.dropFailedModule(packageState);
                        return false;
                    }
                    ++n2;
                }
                ModuleInfo[] moduleInfoArray2 = module.getOptionalModules();
                int n3 = 0;
                while (n3 < moduleInfoArray2.length) {
                    if (!this.loadModule(moduleInfoArray2[n3], arrayList, arrayList2, true)) {
                        Log.debug(new Log.SimpleMessage("Optional module: ", moduleInfoArray2[n3].getModuleClass(), " was not loaded."));
                    }
                    ++n3;
                }
                if (this.containsModule(arrayList2, module) == 1) {
                    arrayList2.add(module);
                }
                arrayList.remove(module);
            }
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (bl) {
                Log.warn(new Log.SimpleMessage("Unresolved dependency for package: ", moduleInfo.getModuleClass()));
            }
            Log.debug(new Log.SimpleMessage("ClassNotFound: ", classNotFoundException.getMessage()));
            return false;
        }
        catch (Exception exception) {
            Log.warn(new Log.SimpleMessage("Exception while loading module: ", moduleInfo), exception);
            return false;
        }
    }

    private boolean acceptVersion(ModuleInfo moduleInfo, Module module) {
        int n;
        if (moduleInfo.getMajorVersion() == null) {
            return true;
        }
        if (module.getMajorVersion() == null) {
            Log.warn("Module " + module.getName() + " does not define a major version.");
        } else {
            n = this.acceptVersion(moduleInfo.getMajorVersion(), module.getMajorVersion());
            if (n > 0) {
                return false;
            }
            if (n < 0) {
                return true;
            }
        }
        if (moduleInfo.getMinorVersion() == null) {
            return true;
        }
        if (module.getMinorVersion() == null) {
            Log.warn("Module " + module.getName() + " does not define a minor version.");
        } else {
            n = this.acceptVersion(moduleInfo.getMinorVersion(), module.getMinorVersion());
            if (n > 0) {
                return false;
            }
            if (n < 0) {
                return true;
            }
        }
        if (moduleInfo.getPatchLevel() == null) {
            return true;
        }
        if (module.getPatchLevel() == null) {
            Log.debug("Module " + module.getName() + " does not define a patch level.");
        } else if (this.acceptVersion(moduleInfo.getPatchLevel(), module.getPatchLevel()) > 0) {
            Log.debug("Did not accept patchlevel: " + moduleInfo.getPatchLevel() + " - " + module.getPatchLevel());
            return false;
        }
        return true;
    }

    private int acceptVersion(String string, String string2) {
        char[] cArray;
        char[] cArray2;
        int n = Math.max(string.length(), string2.length());
        if (string.length() > string2.length()) {
            cArray2 = string.toCharArray();
            cArray = new char[n];
            int n2 = string.length() - string2.length();
            Arrays.fill(cArray, 0, n2, ' ');
            System.arraycopy(cArray, n2, string2.toCharArray(), 0, string2.length());
        } else if (string.length() < string2.length()) {
            cArray = string2.toCharArray();
            cArray2 = new char[n];
            char[] cArray3 = new char[n];
            int n3 = string2.length() - string.length();
            Arrays.fill(cArray3, 0, n3, ' ');
            System.arraycopy(cArray3, n3, string.toCharArray(), 0, string.length());
        } else {
            cArray = string2.toCharArray();
            cArray2 = string.toCharArray();
        }
        return new String(cArray2).compareTo(new String(cArray));
    }

    public PackageConfiguration getPackageConfiguration() {
        return this.packageConfiguration;
    }

    public Module[] getAllModules() {
        Module[] moduleArray = new Module[this.modules.size()];
        int n = 0;
        while (n < this.modules.size()) {
            PackageState packageState = (PackageState)this.modules.get(n);
            moduleArray[n] = packageState.getModule();
            ++n;
        }
        return moduleArray;
    }

    public Module[] getActiveModules() {
        ArrayList<Module> arrayList = new ArrayList<Module>();
        int n = 0;
        while (n < this.modules.size()) {
            PackageState packageState = (PackageState)this.modules.get(n);
            if (packageState.getState() == 2) {
                arrayList.add(packageState.getModule());
            }
            ++n;
        }
        return arrayList.toArray(new Module[arrayList.size()]);
    }

    public void printUsedModules(PrintStream printStream) {
        Module[] moduleArray = this.getAllModules();
        ArrayList<Module> arrayList = new ArrayList<Module>();
        ArrayList<Module> arrayList2 = new ArrayList<Module>();
        int n = 0;
        while (n < moduleArray.length) {
            if (this.isModuleAvailable(moduleArray[n])) {
                arrayList.add(moduleArray[n]);
            } else {
                arrayList2.add(moduleArray[n]);
            }
            ++n;
        }
        printStream.print("Active modules: ");
        printStream.println(arrayList.size());
        printStream.println("----------------------------------------------------------");
        n = 0;
        while (n < arrayList.size()) {
            Module module = (Module)arrayList.get(n);
            printStream.print(new PadMessage(module.getModuleClass(), 70));
            printStream.print(" [");
            printStream.print(module.getSubSystem());
            printStream.println("]");
            printStream.print("  Version: ");
            printStream.print(module.getMajorVersion());
            printStream.print("-");
            printStream.print(module.getMinorVersion());
            printStream.print("-");
            printStream.print(module.getPatchLevel());
            printStream.print(" Producer: ");
            printStream.println(module.getProducer());
            printStream.print("  Description: ");
            printStream.println(module.getDescription());
            ++n;
        }
    }

    public static class PackageConfiguration
    extends PropertyFileConfiguration {
        public void insertConfiguration(HierarchicalConfiguration hierarchicalConfiguration) {
            super.insertConfiguration(hierarchicalConfiguration);
        }
    }
}

