/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.AttributeList;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.ContentList;
import org.jdom.DescendantIterator;
import org.jdom.Document;
import org.jdom.EntityRef;
import org.jdom.FilterIterator;
import org.jdom.IllegalAddException;
import org.jdom.IllegalNameException;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;

public class Element
extends Content
implements Parent {
    private static final String CVS_ID = "@(#) $RCSfile: Element.java,v $ $Revision: 1.152 $ $Date: 2004/09/03 06:35:39 $ $Name: jdom_1_0 $";
    private static final int INITIAL_ARRAY_SIZE = 5;
    protected String name;
    protected transient Namespace namespace;
    protected transient List additionalNamespaces;
    AttributeList attributes = new AttributeList(this);
    ContentList content = new ContentList(this);

    protected Element() {
    }

    public Element(String string, Namespace namespace) {
        this.setName(string);
        this.setNamespace(namespace);
    }

    public Element(String string) {
        this(string, (Namespace)null);
    }

    public Element(String string, String string2) {
        this(string, Namespace.getNamespace("", string2));
    }

    public Element(String string, String string2, String string3) {
        this(string, Namespace.getNamespace(string2, string3));
    }

    public String getName() {
        return this.name;
    }

    public Element setName(String string) {
        String string2 = Verifier.checkElementName(string);
        if (string2 != null) {
            throw new IllegalNameException(string, "element", string2);
        }
        this.name = string;
        return this;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public Element setNamespace(Namespace namespace) {
        if (namespace == null) {
            namespace = Namespace.NO_NAMESPACE;
        }
        this.namespace = namespace;
        return this;
    }

    public String getNamespacePrefix() {
        return this.namespace.getPrefix();
    }

    public String getNamespaceURI() {
        return this.namespace.getURI();
    }

    public Namespace getNamespace(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("xml")) {
            return Namespace.XML_NAMESPACE;
        }
        if (string.equals(this.getNamespacePrefix())) {
            return this.getNamespace();
        }
        if (this.additionalNamespaces != null) {
            int n = 0;
            while (n < this.additionalNamespaces.size()) {
                Namespace namespace = (Namespace)this.additionalNamespaces.get(n);
                if (string.equals(namespace.getPrefix())) {
                    return namespace;
                }
                ++n;
            }
        }
        if (this.parent instanceof Element) {
            return ((Element)this.parent).getNamespace(string);
        }
        return null;
    }

    public String getQualifiedName() {
        if (this.namespace.getPrefix().equals("")) {
            return this.getName();
        }
        return new StringBuffer(this.namespace.getPrefix()).append(':').append(this.name).toString();
    }

    public void addNamespaceDeclaration(Namespace namespace) {
        String string = Verifier.checkNamespaceCollision(namespace, this);
        if (string != null) {
            throw new IllegalAddException(this, namespace, string);
        }
        if (this.additionalNamespaces == null) {
            this.additionalNamespaces = new ArrayList(5);
        }
        this.additionalNamespaces.add(namespace);
    }

    public void removeNamespaceDeclaration(Namespace namespace) {
        if (this.additionalNamespaces == null) {
            return;
        }
        this.additionalNamespaces.remove(namespace);
    }

    public List getAdditionalNamespaces() {
        if (this.additionalNamespaces == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.additionalNamespaces);
    }

    public String getValue() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Content content : this.getContent()) {
            if (!(content instanceof Element) && !(content instanceof Text)) continue;
            stringBuffer.append(content.getValue());
        }
        return stringBuffer.toString();
    }

    public boolean isRootElement() {
        return this.parent instanceof Document;
    }

    public int getContentSize() {
        return this.content.size();
    }

    public int indexOf(Content content) {
        return this.content.indexOf(content);
    }

    public String getText() {
        if (this.content.size() == 0) {
            return "";
        }
        if (this.content.size() == 1) {
            Object object = this.content.get(0);
            if (object instanceof Text) {
                return ((Text)object).getText();
            }
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        while (n < this.content.size()) {
            Object object = this.content.get(n);
            if (object instanceof Text) {
                stringBuffer.append(((Text)object).getText());
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            return "";
        }
        return stringBuffer.toString();
    }

    public String getTextTrim() {
        return this.getText().trim();
    }

    public String getTextNormalize() {
        return Text.normalizeString(this.getText());
    }

    public String getChildText(String string) {
        Element element = this.getChild(string);
        if (element == null) {
            return null;
        }
        return element.getText();
    }

    public String getChildTextTrim(String string) {
        Element element = this.getChild(string);
        if (element == null) {
            return null;
        }
        return element.getTextTrim();
    }

    public String getChildTextNormalize(String string) {
        Element element = this.getChild(string);
        if (element == null) {
            return null;
        }
        return element.getTextNormalize();
    }

    public String getChildText(String string, Namespace namespace) {
        Element element = this.getChild(string, namespace);
        if (element == null) {
            return null;
        }
        return element.getText();
    }

    public String getChildTextTrim(String string, Namespace namespace) {
        Element element = this.getChild(string, namespace);
        if (element == null) {
            return null;
        }
        return element.getTextTrim();
    }

    public String getChildTextNormalize(String string, Namespace namespace) {
        Element element = this.getChild(string, namespace);
        if (element == null) {
            return null;
        }
        return element.getTextNormalize();
    }

    public Element setText(String string) {
        this.content.clear();
        if (string != null) {
            this.addContent(new Text(string));
        }
        return this;
    }

    public List getContent() {
        return this.content;
    }

    public List getContent(Filter filter) {
        return this.content.getView(filter);
    }

    public List removeContent() {
        ArrayList arrayList = new ArrayList(this.content);
        this.content.clear();
        return arrayList;
    }

    public List removeContent(Filter filter) {
        ArrayList<Content> arrayList = new ArrayList<Content>();
        Iterator iterator = this.content.getView(filter).iterator();
        while (iterator.hasNext()) {
            Content content = (Content)iterator.next();
            arrayList.add(content);
            iterator.remove();
        }
        return arrayList;
    }

    public Element setContent(Collection collection) {
        this.content.clearAndSet(collection);
        return this;
    }

    public Element setContent(int n, Content content) {
        this.content.set(n, content);
        return this;
    }

    public Parent setContent(int n, Collection collection) {
        this.content.remove(n);
        this.content.addAll(n, collection);
        return this;
    }

    public Element addContent(String string) {
        return this.addContent(new Text(string));
    }

    public Element addContent(Content content) {
        this.content.add(content);
        return this;
    }

    public Element addContent(Collection collection) {
        this.content.addAll(collection);
        return this;
    }

    public Element addContent(int n, Content content) {
        this.content.add(n, content);
        return this;
    }

    public Element addContent(int n, Collection collection) {
        this.content.addAll(n, collection);
        return this;
    }

    public List cloneContent() {
        int n = this.getContentSize();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            Content content = this.getContent(n2);
            arrayList.add(content.clone());
            ++n2;
        }
        return arrayList;
    }

    public Content getContent(int n) {
        return (Content)this.content.get(n);
    }

    public boolean removeContent(Content content) {
        return this.content.remove(content);
    }

    public Content removeContent(int n) {
        return (Content)this.content.remove(n);
    }

    public Element setContent(Content content) {
        this.content.clear();
        this.content.add(content);
        return this;
    }

    public boolean isAncestor(Element element) {
        Parent parent = element.getParent();
        while (parent instanceof Element) {
            if (parent == this) {
                return true;
            }
            parent = ((Element)parent).getParent();
        }
        return false;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public Attribute getAttribute(String string) {
        return this.getAttribute(string, Namespace.NO_NAMESPACE);
    }

    public Attribute getAttribute(String string, Namespace namespace) {
        return (Attribute)this.attributes.get(string, namespace);
    }

    public String getAttributeValue(String string) {
        return this.getAttributeValue(string, Namespace.NO_NAMESPACE);
    }

    public String getAttributeValue(String string, String string2) {
        return this.getAttributeValue(string, Namespace.NO_NAMESPACE, string2);
    }

    public String getAttributeValue(String string, Namespace namespace) {
        return this.getAttributeValue(string, namespace, null);
    }

    public String getAttributeValue(String string, Namespace namespace, String string2) {
        Attribute attribute = (Attribute)this.attributes.get(string, namespace);
        return attribute == null ? string2 : attribute.getValue();
    }

    public Element setAttributes(List list) {
        this.attributes.clearAndSet(list);
        return this;
    }

    public Element setAttribute(String string, String string2) {
        return this.setAttribute(new Attribute(string, string2));
    }

    public Element setAttribute(String string, String string2, Namespace namespace) {
        return this.setAttribute(new Attribute(string, string2, namespace));
    }

    public Element setAttribute(Attribute attribute) {
        this.attributes.add(attribute);
        return this;
    }

    public boolean removeAttribute(String string) {
        return this.removeAttribute(string, Namespace.NO_NAMESPACE);
    }

    public boolean removeAttribute(String string, Namespace namespace) {
        return this.attributes.remove(string, namespace);
    }

    public boolean removeAttribute(Attribute attribute) {
        return this.attributes.remove(attribute);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64).append("[Element: <").append(this.getQualifiedName());
        String string = this.getNamespaceURI();
        if (!string.equals("")) {
            stringBuffer.append(" [Namespace: ").append(string).append("]");
        }
        stringBuffer.append("/>]");
        return stringBuffer.toString();
    }

    public Object clone() {
        Cloneable cloneable;
        Object object;
        int n;
        Element element = null;
        element = (Element)super.clone();
        element.content = new ContentList(element);
        element.attributes = new AttributeList(element);
        if (this.attributes != null) {
            n = 0;
            while (n < this.attributes.size()) {
                object = this.attributes.get(n);
                cloneable = (Attribute)((Attribute)object).clone();
                element.attributes.add(cloneable);
                ++n;
            }
        }
        if (this.additionalNamespaces != null) {
            n = this.additionalNamespaces.size();
            element.additionalNamespaces = new ArrayList(n);
            int n2 = 0;
            while (n2 < n) {
                cloneable = this.additionalNamespaces.get(n2);
                element.additionalNamespaces.add(cloneable);
                ++n2;
            }
        }
        if (this.content != null) {
            n = 0;
            while (n < this.content.size()) {
                object = this.content.get(n);
                if (object instanceof Element) {
                    cloneable = (Element)((Element)object).clone();
                    element.content.add(cloneable);
                } else if (object instanceof CDATA) {
                    cloneable = (CDATA)((CDATA)object).clone();
                    element.content.add(cloneable);
                } else if (object instanceof Text) {
                    cloneable = (Text)((Text)object).clone();
                    element.content.add(cloneable);
                } else if (object instanceof Comment) {
                    cloneable = (Comment)((Comment)object).clone();
                    element.content.add(cloneable);
                } else if (object instanceof ProcessingInstruction) {
                    cloneable = (ProcessingInstruction)((ProcessingInstruction)object).clone();
                    element.content.add(cloneable);
                } else if (object instanceof EntityRef) {
                    cloneable = (EntityRef)((EntityRef)object).clone();
                    element.content.add(cloneable);
                }
                ++n;
            }
        }
        if (this.additionalNamespaces != null) {
            element.additionalNamespaces = new ArrayList();
            element.additionalNamespaces.addAll(this.additionalNamespaces);
        }
        return element;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.namespace.getPrefix());
        objectOutputStream.writeObject(this.namespace.getURI());
        if (this.additionalNamespaces == null) {
            objectOutputStream.write(0);
        } else {
            int n = this.additionalNamespaces.size();
            objectOutputStream.write(n);
            int n2 = 0;
            while (n2 < n) {
                Namespace namespace = (Namespace)this.additionalNamespaces.get(n2);
                objectOutputStream.writeObject(namespace.getPrefix());
                objectOutputStream.writeObject(namespace.getURI());
                ++n2;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.namespace = Namespace.getNamespace((String)objectInputStream.readObject(), (String)objectInputStream.readObject());
        int n = objectInputStream.read();
        if (n != 0) {
            this.additionalNamespaces = new ArrayList(n);
            int n2 = 0;
            while (n2 < n) {
                Namespace namespace = Namespace.getNamespace((String)objectInputStream.readObject(), (String)objectInputStream.readObject());
                this.additionalNamespaces.add(namespace);
                ++n2;
            }
        }
    }

    public Iterator getDescendants() {
        return new DescendantIterator(this);
    }

    public Iterator getDescendants(Filter filter) {
        return new FilterIterator(new DescendantIterator(this), filter);
    }

    public List getChildren() {
        return this.content.getView(new ElementFilter());
    }

    public List getChildren(String string) {
        return this.getChildren(string, Namespace.NO_NAMESPACE);
    }

    public List getChildren(String string, Namespace namespace) {
        return this.content.getView(new ElementFilter(string, namespace));
    }

    public Element getChild(String string, Namespace namespace) {
        List list = this.content.getView(new ElementFilter(string, namespace));
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            return (Element)iterator.next();
        }
        return null;
    }

    public Element getChild(String string) {
        return this.getChild(string, Namespace.NO_NAMESPACE);
    }

    public boolean removeChild(String string) {
        return this.removeChild(string, Namespace.NO_NAMESPACE);
    }

    public boolean removeChild(String string, Namespace namespace) {
        List list = this.content.getView(new ElementFilter(string, namespace));
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean removeChildren(String string) {
        return this.removeChildren(string, Namespace.NO_NAMESPACE);
    }

    public boolean removeChildren(String string, Namespace namespace) {
        boolean bl = false;
        List list = this.content.getView(new ElementFilter(string, namespace));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
            bl = true;
        }
        return bl;
    }
}

