/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.JavadocAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.JavadocFieldReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocMessageSend;
import org.eclipse.jdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class Javadoc
extends ASTNode {
    public JavadocSingleNameReference[] paramReferences;
    public JavadocSingleTypeReference[] paramTypeParameters;
    public TypeReference[] exceptionReferences;
    public JavadocReturnStatement returnStatement;
    public Expression[] seeReferences;
    public long inheritedPositions = -1L;
    public JavadocSingleNameReference[] invalidParameters;

    public Javadoc(int n, int n2) {
        this.sourceStart = n;
        this.sourceEnd = n2;
    }

    public StringBuffer print(int n, StringBuffer stringBuffer) {
        int n2;
        int n3;
        Javadoc.printIndent(n, stringBuffer).append("/**\n");
        if (this.paramReferences != null) {
            n3 = 0;
            n2 = this.paramReferences.length;
            while (n3 < n2) {
                Javadoc.printIndent(n + 1, stringBuffer).append(" * @param ");
                this.paramReferences[n3].print(n, stringBuffer).append('\n');
                ++n3;
            }
        }
        if (this.paramTypeParameters != null) {
            n3 = 0;
            n2 = this.paramTypeParameters.length;
            while (n3 < n2) {
                Javadoc.printIndent(n + 1, stringBuffer).append(" * @param <");
                this.paramTypeParameters[n3].print(n, stringBuffer).append(">\n");
                ++n3;
            }
        }
        if (this.returnStatement != null) {
            Javadoc.printIndent(n + 1, stringBuffer).append(" * @");
            this.returnStatement.print(n, stringBuffer).append('\n');
        }
        if (this.exceptionReferences != null) {
            n3 = 0;
            n2 = this.exceptionReferences.length;
            while (n3 < n2) {
                Javadoc.printIndent(n + 1, stringBuffer).append(" * @throws ");
                this.exceptionReferences[n3].print(n, stringBuffer).append('\n');
                ++n3;
            }
        }
        if (this.seeReferences != null) {
            n3 = 0;
            n2 = this.seeReferences.length;
            while (n3 < n2) {
                Javadoc.printIndent(n + 1, stringBuffer).append(" * @see ");
                this.seeReferences[n3].print(n, stringBuffer).append('\n');
                ++n3;
            }
        }
        Javadoc.printIndent(n, stringBuffer).append(" */\n");
        return stringBuffer;
    }

    public void resolve(ClassScope classScope) {
        int n = this.paramReferences == null ? 0 : this.paramReferences.length;
        int n2 = 0;
        while (n2 < n) {
            JavadocSingleNameReference javadocSingleNameReference = this.paramReferences[n2];
            classScope.problemReporter().javadocUnexpectedTag(javadocSingleNameReference.tagSourceStart, javadocSingleNameReference.tagSourceEnd);
            ++n2;
        }
        this.resolveTypeParameterTags(classScope, true);
        if (this.returnStatement != null) {
            classScope.problemReporter().javadocUnexpectedTag(this.returnStatement.sourceStart, this.returnStatement.sourceEnd);
        }
        n2 = this.exceptionReferences == null ? 0 : this.exceptionReferences.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5;
            TypeReference typeReference;
            TypeReference typeReference2 = this.exceptionReferences[n3];
            if (typeReference2 instanceof JavadocSingleTypeReference) {
                typeReference = (JavadocSingleTypeReference)typeReference2;
                n5 = typeReference.tagSourceStart;
                n4 = typeReference.tagSourceEnd;
            } else if (typeReference2 instanceof JavadocQualifiedTypeReference) {
                typeReference = (JavadocQualifiedTypeReference)typeReference2;
                n5 = ((JavadocQualifiedTypeReference)typeReference).tagSourceStart;
                n4 = ((JavadocQualifiedTypeReference)typeReference).tagSourceEnd;
            } else {
                n5 = typeReference2.sourceStart;
                n4 = typeReference2.sourceEnd;
            }
            classScope.problemReporter().javadocUnexpectedTag(n5, n4);
            ++n3;
        }
        n3 = this.seeReferences == null ? 0 : this.seeReferences.length;
        int n6 = 0;
        while (n6 < n3) {
            this.resolveReference(this.seeReferences[n6], classScope);
            ++n6;
        }
    }

    public void resolve(MethodScope methodScope) {
        AbstractMethodDeclaration abstractMethodDeclaration = methodScope.referenceMethod();
        boolean bl = abstractMethodDeclaration == null || abstractMethodDeclaration.binding == null ? false : !abstractMethodDeclaration.binding.isStatic() && (abstractMethodDeclaration.binding.modifiers & 0x30000000) != 0;
        int n = this.seeReferences == null ? 0 : this.seeReferences.length;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < n) {
            this.resolveReference(this.seeReferences[n2], methodScope);
            try {
                if (abstractMethodDeclaration != null && (abstractMethodDeclaration.isConstructor() || bl) && !bl2) {
                    Expression expression;
                    if (this.seeReferences[n2] instanceof JavadocMessageSend) {
                        ReferenceBinding referenceBinding;
                        expression = (JavadocMessageSend)this.seeReferences[n2];
                        if (expression.binding != null && expression.binding.isValidBinding() && expression.actualReceiverType instanceof ReferenceBinding && ((referenceBinding = (ReferenceBinding)expression.actualReceiverType).isSuperclassOf(abstractMethodDeclaration.binding.declaringClass) || referenceBinding.isInterface() && abstractMethodDeclaration.binding.declaringClass.implementsInterface(referenceBinding, true)) && CharOperation.equals(expression.selector, abstractMethodDeclaration.selector) && abstractMethodDeclaration.binding.returnType.isCompatibleWith(expression.binding.returnType)) {
                            if (expression.arguments == null && abstractMethodDeclaration.arguments == null) {
                                bl2 = true;
                            } else if (expression.arguments != null && abstractMethodDeclaration.arguments != null) {
                                bl2 = abstractMethodDeclaration.binding.areParameterErasuresEqual(expression.binding);
                            }
                        }
                    } else if (this.seeReferences[n2] instanceof JavadocAllocationExpression) {
                        expression = (JavadocAllocationExpression)this.seeReferences[n2];
                        if (((JavadocAllocationExpression)expression).binding != null && ((JavadocAllocationExpression)expression).binding.isValidBinding() && abstractMethodDeclaration.binding.declaringClass.isCompatibleWith(((JavadocAllocationExpression)expression).resolvedType)) {
                            if (((JavadocAllocationExpression)expression).arguments == null && abstractMethodDeclaration.arguments == null) {
                                bl2 = true;
                            } else if (((JavadocAllocationExpression)expression).arguments != null && abstractMethodDeclaration.arguments != null) {
                                bl2 = abstractMethodDeclaration.binding.areParametersCompatibleWith(((JavadocAllocationExpression)expression).binding.parameters);
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
        if (!bl2 && abstractMethodDeclaration != null && abstractMethodDeclaration.annotations != null) {
            n2 = abstractMethodDeclaration.annotations.length;
            int n3 = 0;
            while (n3 < n2 && !bl2) {
                bl2 = (abstractMethodDeclaration.binding.tagBits & 0x1000000000000L) != 0L;
                ++n3;
            }
        }
        int n4 = n2 = abstractMethodDeclaration != null && (bl && this.inheritedPositions != -1L || bl2 || abstractMethodDeclaration.binding.declaringClass != null && abstractMethodDeclaration.binding.declaringClass.isLocalType()) ? 0 : 1;
        if (!bl && this.inheritedPositions != -1L) {
            int n5 = (int)(this.inheritedPositions >>> 32);
            int n6 = (int)this.inheritedPositions;
            methodScope.problemReporter().javadocUnexpectedTag(n5, n6);
        }
        this.resolveParamTags(methodScope, n2 != 0);
        this.resolveTypeParameterTags(methodScope, n2 != 0);
        if (this.returnStatement == null) {
            if (n2 != 0 && abstractMethodDeclaration != null && abstractMethodDeclaration.isMethod()) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)abstractMethodDeclaration;
                if (methodDeclaration.binding.returnType != TypeBinding.VOID) {
                    methodScope.problemReporter().javadocMissingReturnTag(methodDeclaration.returnType.sourceStart, methodDeclaration.returnType.sourceEnd, abstractMethodDeclaration.binding.modifiers);
                }
            }
        } else {
            this.returnStatement.resolve(methodScope);
        }
        this.resolveThrowsTags(methodScope, n2 != 0);
        int n7 = this.invalidParameters == null ? 0 : this.invalidParameters.length;
        int n8 = 0;
        while (n8 < n7) {
            this.invalidParameters[n8].resolve(methodScope, false);
            ++n8;
        }
    }

    private void resolveReference(Expression expression, Scope scope) {
        boolean bl;
        switch (scope.kind) {
            case 2: {
                expression.resolveType((MethodScope)scope);
                break;
            }
            case 3: {
                expression.resolveType((ClassScope)scope);
            }
        }
        boolean bl2 = bl = scope.compilerOptions().sourceLevel >= 0x310000L;
        if (expression instanceof JavadocFieldReference) {
            int n;
            JavadocFieldReference javadocFieldReference = (JavadocFieldReference)expression;
            int n2 = n = javadocFieldReference.binding == null ? -1 : javadocFieldReference.binding.modifiers;
            if (javadocFieldReference.methodBinding != null) {
                if (javadocFieldReference.tagValue == 10) {
                    scope.problemReporter().javadocInvalidValueReference(javadocFieldReference.sourceStart, javadocFieldReference.sourceEnd, n);
                } else if (javadocFieldReference.receiverType != null) {
                    javadocFieldReference.superAccess = scope.enclosingSourceType().isCompatibleWith(javadocFieldReference.receiverType);
                    javadocFieldReference.methodBinding = scope.findMethod((ReferenceBinding)javadocFieldReference.receiverType, javadocFieldReference.token, new TypeBinding[0], javadocFieldReference);
                }
            } else if (bl && javadocFieldReference.binding != null && javadocFieldReference.binding.isValidBinding() && javadocFieldReference.tagValue == 10 && !javadocFieldReference.binding.isStatic()) {
                scope.problemReporter().javadocInvalidValueReference(javadocFieldReference.sourceStart, javadocFieldReference.sourceEnd, n);
            }
            return;
        }
        if (!bl) {
            return;
        }
        if (expression instanceof JavadocMessageSend) {
            int n;
            JavadocMessageSend javadocMessageSend = (JavadocMessageSend)expression;
            int n3 = n = javadocMessageSend.binding == null ? -1 : javadocMessageSend.binding.modifiers;
            if (javadocMessageSend.tagValue == 10) {
                scope.problemReporter().javadocInvalidValueReference(javadocMessageSend.sourceStart, javadocMessageSend.sourceEnd, n);
            }
        } else if (expression instanceof JavadocAllocationExpression) {
            int n;
            JavadocAllocationExpression javadocAllocationExpression = (JavadocAllocationExpression)expression;
            int n4 = n = javadocAllocationExpression.binding == null ? -1 : javadocAllocationExpression.binding.modifiers;
            if (javadocAllocationExpression.tagValue == 10) {
                scope.problemReporter().javadocInvalidValueReference(javadocAllocationExpression.sourceStart, javadocAllocationExpression.sourceEnd, n);
            }
        }
        if (expression.resolvedType != null && expression.resolvedType.isTypeVariable()) {
            scope.problemReporter().javadocInvalidReference(expression.sourceStart, expression.sourceEnd);
        }
    }

    private void resolveParamTags(MethodScope methodScope, boolean bl) {
        block14: {
            int n;
            boolean bl2;
            Statement statement;
            int n2;
            int n3;
            AbstractMethodDeclaration abstractMethodDeclaration;
            block13: {
                abstractMethodDeclaration = methodScope.referenceMethod();
                int n4 = n3 = this.paramReferences == null ? 0 : this.paramReferences.length;
                if (abstractMethodDeclaration == null) {
                    int n5 = 0;
                    while (n5 < n3) {
                        JavadocSingleNameReference javadocSingleNameReference = this.paramReferences[n5];
                        methodScope.problemReporter().javadocUnexpectedTag(javadocSingleNameReference.tagSourceStart, javadocSingleNameReference.tagSourceEnd);
                        ++n5;
                    }
                    return;
                }
                int n6 = n2 = abstractMethodDeclaration.arguments == null ? 0 : abstractMethodDeclaration.arguments.length;
                if (n3 != 0) break block13;
                if (!bl) break block14;
                int n7 = 0;
                while (n7 < n2) {
                    Argument argument = abstractMethodDeclaration.arguments[n7];
                    methodScope.problemReporter().javadocMissingParamTag(argument.name, argument.sourceStart, argument.sourceEnd, abstractMethodDeclaration.binding.modifiers);
                    ++n7;
                }
                break block14;
            }
            LocalVariableBinding[] localVariableBindingArray = new LocalVariableBinding[n3];
            int n8 = 0;
            int n9 = 0;
            while (n9 < n3) {
                statement = this.paramReferences[n9];
                statement.resolve(methodScope);
                if (statement.binding != null && statement.binding.isValidBinding()) {
                    bl2 = false;
                    n = 0;
                    while (n < n8 && !bl2) {
                        if (localVariableBindingArray[n] == statement.binding) {
                            methodScope.problemReporter().javadocDuplicatedParamTag(statement.token, statement.sourceStart, statement.sourceEnd, abstractMethodDeclaration.binding.modifiers);
                            bl2 = true;
                        }
                        ++n;
                    }
                    if (!bl2) {
                        localVariableBindingArray[n8++] = (LocalVariableBinding)statement.binding;
                    }
                }
                ++n9;
            }
            if (bl) {
                n9 = 0;
                while (n9 < n2) {
                    statement = abstractMethodDeclaration.arguments[n9];
                    bl2 = false;
                    n = 0;
                    while (n < n8 && !bl2) {
                        LocalVariableBinding localVariableBinding = localVariableBindingArray[n];
                        if (((Argument)statement).binding == localVariableBinding) {
                            bl2 = true;
                        }
                        ++n;
                    }
                    if (!bl2) {
                        methodScope.problemReporter().javadocMissingParamTag(((Argument)statement).name, ((Argument)statement).sourceStart, ((Argument)statement).sourceEnd, abstractMethodDeclaration.binding.modifiers);
                    }
                    ++n9;
                }
            }
        }
    }

    private void resolveTypeParameterTags(Scope scope, boolean bl) {
        block23: {
            int n;
            TypeVariableBinding[] typeVariableBindingArray;
            int n2;
            TypeVariableBinding[] typeVariableBindingArray2;
            TypeParameter[] typeParameterArray;
            int n3;
            block24: {
                n3 = this.paramTypeParameters == null ? 0 : this.paramTypeParameters.length;
                typeParameterArray = null;
                typeVariableBindingArray2 = null;
                n2 = -1;
                switch (scope.kind) {
                    case 2: {
                        AbstractMethodDeclaration abstractMethodDeclaration = ((MethodScope)scope).referenceMethod();
                        if (abstractMethodDeclaration == null) {
                            int n4 = 0;
                            while (n4 < n3) {
                                JavadocSingleNameReference javadocSingleNameReference = this.paramReferences[n4];
                                scope.problemReporter().javadocUnexpectedTag(javadocSingleNameReference.tagSourceStart, javadocSingleNameReference.tagSourceEnd);
                                ++n4;
                            }
                            return;
                        }
                        typeParameterArray = abstractMethodDeclaration.typeParameters();
                        typeVariableBindingArray2 = abstractMethodDeclaration.binding.typeVariables;
                        n2 = abstractMethodDeclaration.binding.modifiers;
                        break;
                    }
                    case 3: {
                        typeVariableBindingArray = ((ClassScope)scope).referenceContext;
                        typeParameterArray = typeVariableBindingArray.typeParameters;
                        typeVariableBindingArray2 = typeVariableBindingArray.binding.typeVariables;
                        n2 = typeVariableBindingArray.binding.modifiers;
                    }
                }
                if (typeVariableBindingArray2 == null || typeVariableBindingArray2.length == 0) {
                    int n5 = 0;
                    while (n5 < n3) {
                        typeVariableBindingArray = this.paramTypeParameters[n5];
                        scope.problemReporter().javadocUnexpectedTag(typeVariableBindingArray.tagSourceStart, typeVariableBindingArray.tagSourceEnd);
                        ++n5;
                    }
                    return;
                }
                if (typeParameterArray == null) break block23;
                n = typeParameterArray.length;
                if (n3 != 0) break block24;
                if (!bl) break block23;
                int n6 = 0;
                int n7 = n;
                while (n6 < n7) {
                    scope.problemReporter().javadocMissingParamTag(typeParameterArray[n6].name, typeParameterArray[n6].sourceStart, typeParameterArray[n6].sourceEnd, n2);
                    ++n6;
                }
                break block23;
            }
            if (typeVariableBindingArray2.length == n) {
                int n8;
                Statement statement;
                typeVariableBindingArray = new TypeVariableBinding[n3];
                int n9 = 0;
                while (n9 < n3) {
                    statement = this.paramTypeParameters[n9];
                    TypeBinding typeBinding = statement.internalResolveType(scope);
                    if (typeBinding != null && typeBinding.isValidBinding()) {
                        if (typeBinding.isTypeVariable()) {
                            n8 = 0;
                            int n10 = 0;
                            while (n10 < n9 && n8 == 0) {
                                if (typeVariableBindingArray[n10] == statement.resolvedType) {
                                    scope.problemReporter().javadocDuplicatedParamTag(statement.token, statement.sourceStart, statement.sourceEnd, n2);
                                    n8 = 1;
                                }
                                ++n10;
                            }
                            if (n8 == 0) {
                                typeVariableBindingArray[n9] = (TypeVariableBinding)statement.resolvedType;
                            }
                        } else {
                            scope.problemReporter().javadocUndeclaredParamTagName(statement.token, statement.sourceStart, statement.sourceEnd, n2);
                        }
                    }
                    ++n9;
                }
                n9 = 0;
                while (n9 < n) {
                    statement = typeParameterArray[n9];
                    boolean bl2 = false;
                    n8 = 0;
                    while (n8 < n3 && !bl2) {
                        if (((TypeParameter)statement).binding == typeVariableBindingArray[n8]) {
                            bl2 = true;
                            typeVariableBindingArray[n8] = null;
                        }
                        ++n8;
                    }
                    if (!bl2 && bl) {
                        scope.problemReporter().javadocMissingParamTag(((TypeParameter)statement).name, ((TypeParameter)statement).sourceStart, ((TypeParameter)statement).sourceEnd, n2);
                    }
                    ++n9;
                }
                n9 = 0;
                while (n9 < n3) {
                    if (typeVariableBindingArray[n9] != null) {
                        statement = this.paramTypeParameters[n9];
                        scope.problemReporter().javadocUndeclaredParamTagName(statement.token, statement.sourceStart, statement.sourceEnd, n2);
                    }
                    ++n9;
                }
            }
        }
    }

    private void resolveThrowsTags(MethodScope methodScope, boolean bl) {
        block24: {
            TypeBinding typeBinding;
            int n;
            Object object;
            int n2;
            int n3;
            int n4;
            AbstractMethodDeclaration abstractMethodDeclaration;
            block23: {
                abstractMethodDeclaration = methodScope.referenceMethod();
                int n5 = n4 = this.exceptionReferences == null ? 0 : this.exceptionReferences.length;
                if (abstractMethodDeclaration == null) {
                    int n6 = 0;
                    while (n6 < n4) {
                        TypeReference typeReference = this.exceptionReferences[n6];
                        int n7 = typeReference.sourceStart;
                        int n8 = typeReference.sourceEnd;
                        if (typeReference instanceof JavadocQualifiedTypeReference) {
                            n7 = ((JavadocQualifiedTypeReference)typeReference).tagSourceStart;
                            n8 = ((JavadocQualifiedTypeReference)typeReference).tagSourceEnd;
                        } else if (typeReference instanceof JavadocSingleTypeReference) {
                            n7 = ((JavadocSingleTypeReference)typeReference).tagSourceStart;
                            n8 = ((JavadocSingleTypeReference)typeReference).tagSourceEnd;
                        }
                        methodScope.problemReporter().javadocUnexpectedTag(n7, n8);
                        ++n6;
                    }
                    return;
                }
                n3 = abstractMethodDeclaration.binding == null || abstractMethodDeclaration.binding.thrownExceptions == null ? 0 : abstractMethodDeclaration.binding.thrownExceptions.length;
                int n9 = n2 = abstractMethodDeclaration.thrownExceptions == null ? 0 : abstractMethodDeclaration.thrownExceptions.length;
                if (n4 != 0) break block23;
                if (!bl) break block24;
                int n10 = 0;
                while (n10 < n3) {
                    ReferenceBinding referenceBinding = abstractMethodDeclaration.binding.thrownExceptions[n10];
                    if (referenceBinding != null && referenceBinding.isValidBinding()) {
                        int n11 = n10;
                        while (n11 < n2 && referenceBinding != abstractMethodDeclaration.thrownExceptions[n11].resolvedType) {
                            ++n11;
                        }
                        if (n11 < n2) {
                            methodScope.problemReporter().javadocMissingThrowsTag(abstractMethodDeclaration.thrownExceptions[n11], abstractMethodDeclaration.binding.modifiers);
                        }
                    }
                    ++n10;
                }
                break block24;
            }
            int n12 = 0;
            TypeReference[] typeReferenceArray = new TypeReference[n4];
            int n13 = 0;
            while (n13 < n4) {
                object = this.exceptionReferences[n13];
                ((Expression)object).resolve(methodScope);
                TypeBinding typeBinding2 = ((TypeReference)object).resolvedType;
                if (typeBinding2 != null && typeBinding2.isValidBinding() && typeBinding2.isClass()) {
                    typeReferenceArray[n12++] = object;
                }
                ++n13;
            }
            n13 = 0;
            while (n13 < n3) {
                object = abstractMethodDeclaration.binding.thrownExceptions[n13];
                if (object != null) {
                    object = (ReferenceBinding)((TypeBinding)object).erasure();
                }
                boolean bl2 = false;
                n = 0;
                while (n < n12 && !bl2) {
                    if (typeReferenceArray[n] != null && object == (typeBinding = typeReferenceArray[n].resolvedType)) {
                        bl2 = true;
                        typeReferenceArray[n] = null;
                    }
                    ++n;
                }
                if (!bl2 && bl && object != null && ((Binding)object).isValidBinding()) {
                    n = n13;
                    while (n < n2 && object != abstractMethodDeclaration.thrownExceptions[n].resolvedType) {
                        ++n;
                    }
                    if (n < n2) {
                        methodScope.problemReporter().javadocMissingThrowsTag(abstractMethodDeclaration.thrownExceptions[n], abstractMethodDeclaration.binding.modifiers);
                    }
                }
                ++n13;
            }
            n13 = 0;
            while (n13 < n12) {
                object = typeReferenceArray[n13];
                if (object != null) {
                    boolean bl3 = false;
                    n = 0;
                    while (n < n2 && !bl3) {
                        typeBinding = abstractMethodDeclaration.thrownExceptions[n].resolvedType;
                        if (typeBinding != null) {
                            bl3 = ((TypeReference)object).resolvedType.isCompatibleWith(typeBinding);
                        }
                        ++n;
                    }
                    if (!bl3 && !((TypeReference)object).resolvedType.isUncheckedException(false)) {
                        methodScope.problemReporter().javadocInvalidThrowsClassName((TypeReference)object, abstractMethodDeclaration.binding.modifiers);
                    }
                }
                ++n13;
            }
        }
    }

    public ASTNode getNodeStartingAt(int n) {
        Expression expression;
        int n2;
        int n3 = 0;
        if (this.paramReferences != null) {
            n3 = this.paramReferences.length;
            n2 = 0;
            while (n2 < n3) {
                expression = this.paramReferences[n2];
                if (expression.sourceStart == n) {
                    return expression;
                }
                ++n2;
            }
        }
        if (this.invalidParameters != null) {
            n3 = this.invalidParameters.length;
            n2 = 0;
            while (n2 < n3) {
                expression = this.invalidParameters[n2];
                if (expression.sourceStart == n) {
                    return expression;
                }
                ++n2;
            }
        }
        if (this.paramTypeParameters != null) {
            n3 = this.paramTypeParameters.length;
            n2 = 0;
            while (n2 < n3) {
                expression = this.paramTypeParameters[n2];
                if (((JavadocSingleTypeReference)expression).sourceStart == n) {
                    return expression;
                }
                ++n2;
            }
        }
        if (this.exceptionReferences != null) {
            n3 = this.exceptionReferences.length;
            n2 = 0;
            while (n2 < n3) {
                expression = this.exceptionReferences[n2];
                if (((TypeReference)expression).sourceStart == n) {
                    return expression;
                }
                ++n2;
            }
        }
        if (this.seeReferences != null) {
            n3 = this.seeReferences.length;
            n2 = 0;
            while (n2 < n3) {
                int n4;
                int n5;
                Expression expression2;
                expression = this.seeReferences[n2];
                if (expression.sourceStart == n) {
                    return expression;
                }
                if (expression instanceof JavadocAllocationExpression) {
                    expression2 = (JavadocAllocationExpression)this.seeReferences[n2];
                    if (expression2.binding != null && expression2.binding.isValidBinding() && expression2.arguments != null) {
                        n5 = 0;
                        n4 = expression2.arguments.length;
                        while (n5 < n4) {
                            if (expression2.arguments[n5].sourceStart == n) {
                                return expression2.arguments[n5];
                            }
                            ++n5;
                        }
                    }
                } else if (expression instanceof JavadocMessageSend) {
                    expression2 = (JavadocMessageSend)this.seeReferences[n2];
                    if (((JavadocMessageSend)expression2).binding != null && ((JavadocMessageSend)expression2).binding.isValidBinding() && ((JavadocMessageSend)expression2).arguments != null) {
                        n5 = 0;
                        n4 = ((JavadocMessageSend)expression2).arguments.length;
                        while (n5 < n4) {
                            if (((JavadocMessageSend)expression2).arguments[n5].sourceStart == n) {
                                return ((JavadocMessageSend)expression2).arguments[n5];
                            }
                            ++n5;
                        }
                    }
                }
                ++n2;
            }
        }
        return null;
    }
}

