/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.NLSTag;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;

public class CompilationUnitDeclaration
extends ASTNode
implements ProblemSeverities,
ReferenceContext {
    private static final Comparator STRING_LITERAL_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            StringLiteral stringLiteral = (StringLiteral)object;
            StringLiteral stringLiteral2 = (StringLiteral)object2;
            return stringLiteral.sourceStart - stringLiteral2.sourceStart;
        }
    };
    private static final int STRING_LITERALS_INCREMENT = 10;
    public ImportReference currentPackage;
    public ImportReference[] imports;
    public TypeDeclaration[] types;
    public int[][] comments;
    public boolean ignoreFurtherInvestigation = false;
    public boolean ignoreMethodBodies = false;
    public CompilationUnitScope scope;
    public ProblemReporter problemReporter;
    public CompilationResult compilationResult;
    public LocalTypeBinding[] localTypes;
    public int localTypeCount = 0;
    public boolean isPropagatingInnerClassEmulation;
    public Javadoc javadoc;
    public NLSTag[] nlsTags;
    private StringLiteral[] stringLiterals;
    private int stringLiteralsPtr;

    public CompilationUnitDeclaration(ProblemReporter problemReporter, CompilationResult compilationResult, int n) {
        this.problemReporter = problemReporter;
        this.compilationResult = compilationResult;
        this.sourceStart = 0;
        this.sourceEnd = n - 1;
    }

    public void abort(int n, CategorizedProblem categorizedProblem) {
        switch (n) {
            case 8: {
                throw new AbortType(this.compilationResult, categorizedProblem);
            }
            case 16: {
                throw new AbortMethod(this.compilationResult, categorizedProblem);
            }
        }
        throw new AbortCompilationUnit(this.compilationResult, categorizedProblem);
    }

    public void analyseCode() {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (this.types != null) {
                int n = 0;
                int n2 = this.types.length;
                while (n < n2) {
                    this.types[n].analyseCode(this.scope);
                    ++n;
                }
            }
            this.propagateInnerEmulationForAllLocalTypes();
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    public void cleanUp() {
        int n;
        if (this.types != null) {
            int n2 = 0;
            n = this.types.length;
            while (n2 < n) {
                this.cleanUp(this.types[n2]);
                ++n2;
            }
            n2 = 0;
            n = this.localTypeCount;
            while (n2 < n) {
                LocalTypeBinding localTypeBinding = this.localTypes[n2];
                localTypeBinding.scope = null;
                localTypeBinding.enclosingCase = null;
                ++n2;
            }
        }
        this.compilationResult.recoveryScannerData = null;
        ClassFile[] classFileArray = this.compilationResult.getClassFiles();
        n = 0;
        int n3 = classFileArray.length;
        while (n < n3) {
            ClassFile classFile = classFileArray[n];
            classFile.referenceBinding = null;
            classFile.innerClassesBindings = null;
            ++n;
        }
    }

    private void cleanUp(TypeDeclaration typeDeclaration) {
        if (typeDeclaration.memberTypes != null) {
            int n = 0;
            int n2 = typeDeclaration.memberTypes.length;
            while (n < n2) {
                this.cleanUp(typeDeclaration.memberTypes[n]);
                ++n;
            }
        }
        if (typeDeclaration.binding != null && typeDeclaration.binding.isAnnotationType()) {
            this.compilationResult.hasAnnotations = true;
        }
        if (typeDeclaration.binding != null) {
            typeDeclaration.binding.scope = null;
        }
    }

    public void checkUnusedImports() {
        if (this.scope.imports != null) {
            int n = 0;
            int n2 = this.scope.imports.length;
            while (n < n2) {
                ImportBinding importBinding = this.scope.imports[n];
                ImportReference importReference = importBinding.reference;
                if (importReference != null && !importReference.used) {
                    this.scope.problemReporter().unusedImport(importReference);
                }
                ++n;
            }
        }
    }

    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public TypeDeclaration declarationOfType(char[][] cArray) {
        int n = 0;
        while (n < this.types.length) {
            TypeDeclaration typeDeclaration = this.types[n].declarationOfType(cArray);
            if (typeDeclaration != null) {
                return typeDeclaration;
            }
            ++n;
        }
        return null;
    }

    public void generateCode() {
        if (this.ignoreFurtherInvestigation) {
            if (this.types != null) {
                int n = 0;
                int n2 = this.types.length;
                while (n < n2) {
                    this.types[n].ignoreFurtherInvestigation = true;
                    this.types[n].generateCode(this.scope);
                    ++n;
                }
            }
            return;
        }
        if (this.isPackageInfo() && this.types != null && this.currentPackage.annotations != null) {
            this.types[0].annotations = this.currentPackage.annotations;
        }
        try {
            if (this.types != null) {
                int n = 0;
                int n3 = this.types.length;
                while (n < n3) {
                    this.types[n].generateCode(this.scope);
                    ++n;
                }
            }
        }
        catch (AbortCompilationUnit abortCompilationUnit) {}
    }

    public char[] getFileName() {
        return this.compilationResult.getFileName();
    }

    public char[] getMainTypeName() {
        if (this.compilationResult.compilationUnit == null) {
            int n;
            char[] cArray = this.compilationResult.getFileName();
            int n2 = CharOperation.lastIndexOf('/', cArray) + 1;
            if (n2 == 0 || n2 < CharOperation.lastIndexOf('\\', cArray)) {
                n2 = CharOperation.lastIndexOf('\\', cArray) + 1;
            }
            if ((n = CharOperation.lastIndexOf('.', cArray)) == -1) {
                n = cArray.length;
            }
            return CharOperation.subarray(cArray, n2, n);
        }
        return this.compilationResult.compilationUnit.getMainTypeName();
    }

    public boolean isEmpty() {
        return this.currentPackage == null && this.imports == null && this.types == null;
    }

    public boolean isPackageInfo() {
        return CharOperation.equals(this.getMainTypeName(), TypeConstants.PACKAGE_INFO_NAME) && this.currentPackage != null && (this.currentPackage.annotations != null || this.javadoc != null);
    }

    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    public StringBuffer print(int n, StringBuffer stringBuffer) {
        int n2;
        if (this.currentPackage != null) {
            CompilationUnitDeclaration.printIndent(n, stringBuffer).append("package ");
            this.currentPackage.print(0, stringBuffer, false).append(";\n");
        }
        if (this.imports != null) {
            n2 = 0;
            while (n2 < this.imports.length) {
                CompilationUnitDeclaration.printIndent(n, stringBuffer).append("import ");
                this.imports[n2].print(0, stringBuffer).append(";\n");
                ++n2;
            }
        }
        if (this.types != null) {
            n2 = 0;
            while (n2 < this.types.length) {
                this.types[n2].print(n, stringBuffer).append("\n");
                ++n2;
            }
        }
        return stringBuffer;
    }

    public void propagateInnerEmulationForAllLocalTypes() {
        this.isPropagatingInnerClassEmulation = true;
        int n = 0;
        int n2 = this.localTypeCount;
        while (n < n2) {
            LocalTypeBinding localTypeBinding = this.localTypes[n];
            if ((localTypeBinding.scope.referenceType().bits & Integer.MIN_VALUE) != 0) {
                localTypeBinding.updateInnerEmulationDependents();
            }
            ++n;
        }
    }

    public void recordStringLiteral(StringLiteral stringLiteral) {
        if (this.stringLiterals == null) {
            this.stringLiterals = new StringLiteral[10];
            this.stringLiteralsPtr = 0;
        } else {
            int n = this.stringLiterals.length;
            if (this.stringLiteralsPtr == n) {
                this.stringLiterals = new StringLiteral[n + 10];
                System.arraycopy(this.stringLiterals, 0, this.stringLiterals, 0, n);
            }
        }
        this.stringLiterals[this.stringLiteralsPtr++] = stringLiteral;
    }

    public void record(LocalTypeBinding localTypeBinding) {
        if (this.localTypeCount == 0) {
            this.localTypes = new LocalTypeBinding[5];
        } else if (this.localTypeCount == this.localTypes.length) {
            this.localTypes = new LocalTypeBinding[this.localTypeCount * 2];
            System.arraycopy(this.localTypes, 0, this.localTypes, 0, this.localTypeCount);
        }
        this.localTypes[this.localTypeCount++] = localTypeBinding;
    }

    public void resolve() {
        int n = 0;
        boolean bl = this.isPackageInfo();
        if (this.types != null && bl) {
            TypeDeclaration typeDeclaration = this.types[0];
            typeDeclaration.javadoc = new Javadoc(typeDeclaration.declarationSourceStart, typeDeclaration.declarationSourceStart);
            typeDeclaration.resolve(this.scope);
            if (this.currentPackage.annotations != null) {
                CompilationUnitDeclaration.resolveAnnotations(typeDeclaration.staticInitializerScope, this.currentPackage.annotations, this.scope.fPackage);
            }
            if (this.javadoc != null) {
                this.javadoc.resolve(typeDeclaration.staticInitializerScope);
            }
            n = 1;
        }
        if (this.currentPackage != null && this.currentPackage.annotations != null && !bl) {
            this.scope.problemReporter().invalidFileNameForPackageAnnotations(this.currentPackage.annotations[0]);
        }
        try {
            if (this.types != null) {
                int n2 = n;
                int n3 = this.types.length;
                while (n2 < n3) {
                    this.types[n2].resolve(this.scope);
                    ++n2;
                }
            }
            if (!this.compilationResult.hasErrors()) {
                this.checkUnusedImports();
            }
            this.reportNLSProblems();
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void reportNLSProblems() {
        block25: {
            block27: {
                block26: {
                    if (this.nlsTags == null && this.stringLiterals == null) break block25;
                    var1_1 = this.stringLiteralsPtr;
                    v0 = var2_2 = this.nlsTags == null ? 0 : this.nlsTags.length;
                    if (var1_1 != 0) break block26;
                    if (var2_2 == 0) break block25;
                    var3_3 = 0;
                    while (var3_3 < var2_2) {
                        var4_6 = this.nlsTags[var3_3];
                        if (var4_6 != null) {
                            this.scope.problemReporter().unnecessaryNLSTags(var4_6.start, var4_6.end);
                        }
                        ++var3_3;
                    }
                    break block25;
                }
                if (var2_2 != 0) break block27;
                if (this.stringLiterals.length != var1_1) {
                    this.stringLiterals = new StringLiteral[var1_1];
                    System.arraycopy(this.stringLiterals, 0, this.stringLiterals, 0, var1_1);
                }
                Arrays.sort(this.stringLiterals, CompilationUnitDeclaration.STRING_LITERAL_COMPARATOR);
                var3_4 = 0;
                while (var3_4 < var1_1) {
                    this.scope.problemReporter().nonExternalizedStringLiteral(this.stringLiterals[var3_4]);
                    ++var3_4;
                }
                break block25;
            }
            if (this.stringLiterals.length != var1_1) {
                this.stringLiterals = new StringLiteral[var1_1];
                System.arraycopy(this.stringLiterals, 0, this.stringLiterals, 0, var1_1);
            }
            Arrays.sort(this.stringLiterals, CompilationUnitDeclaration.STRING_LITERAL_COMPARATOR);
            var3_5 = 1;
            var4_7 = -1;
            var5_8 = null;
            var6_9 = 0;
            var7_10 = 0;
            block2: while (var7_10 < var1_1) {
                var5_8 = this.stringLiterals[var7_10];
                var8_11 = var5_8.lineNumber;
                if (var4_7 != var8_11) {
                    var3_5 = 1;
                    var4_7 = var8_11;
                } else {
                    ++var3_5;
                }
                if (var6_9 >= var2_2) break;
                while (var6_9 < var2_2) {
                    block24: {
                        var9_13 = this.nlsTags[var6_9];
                        if (var9_13 == null) ** GOTO lbl74
                        var10_14 = var9_13.lineNumber;
                        if (var8_11 < var10_14) {
                            this.scope.problemReporter().nonExternalizedStringLiteral(var5_8);
                        } else if (var8_11 == var10_14) {
                            if (var9_13.index == var3_5) {
                                this.nlsTags[var6_9] = null;
                                ++var6_9;
                            } else {
                                var11_15 = var6_9 + 1;
                                while (var11_15 < var2_2) {
                                    var12_16 = this.nlsTags[var11_15];
                                    if (var12_16 != null) {
                                        var13_17 = var12_16.lineNumber;
                                        if (var8_11 == var13_17) {
                                            if (var12_16.index == var3_5) {
                                                this.nlsTags[var11_15] = null;
                                                break block24;
                                            }
                                        } else {
                                            this.scope.problemReporter().nonExternalizedStringLiteral(var5_8);
                                            break block24;
                                        }
                                    }
                                    ++var11_15;
                                }
                                this.scope.problemReporter().nonExternalizedStringLiteral(var5_8);
                            }
                        } else {
                            this.scope.problemReporter().unnecessaryNLSTags(var9_13.start, var9_13.end);
lbl74:
                            // 2 sources

                            ++var6_9;
                            continue;
                        }
                    }
                    ++var7_10;
                    continue block2;
                }
                break block2;
            }
            while (var7_10 < var1_1) {
                this.scope.problemReporter().nonExternalizedStringLiteral(this.stringLiterals[var7_10]);
                ++var7_10;
            }
            if (var6_9 < var2_2) {
                while (var6_9 < var2_2) {
                    var8_12 = this.nlsTags[var6_9];
                    if (var8_12 != null) {
                        this.scope.problemReporter().unnecessaryNLSTags(var8_12.start, var8_12.end);
                    }
                    ++var6_9;
                }
            }
        }
    }

    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    public void traverse(ASTVisitor aSTVisitor, CompilationUnitScope compilationUnitScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (aSTVisitor.visit(this, this.scope)) {
                int n;
                int n2;
                if (this.currentPackage != null) {
                    this.currentPackage.traverse(aSTVisitor, this.scope);
                }
                if (this.imports != null) {
                    n2 = this.imports.length;
                    n = 0;
                    while (n < n2) {
                        this.imports[n].traverse(aSTVisitor, this.scope);
                        ++n;
                    }
                }
                if (this.types != null) {
                    n2 = this.types.length;
                    n = 0;
                    while (n < n2) {
                        this.types[n].traverse(aSTVisitor, this.scope);
                        ++n;
                    }
                }
            }
            aSTVisitor.endVisit(this, this.scope);
        }
        catch (AbortCompilationUnit abortCompilationUnit) {}
    }
}

