/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ContextClassLoaderLocal;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanUtilsBean {
    private static final ContextClassLoaderLocal beansByClassLoader = new ContextClassLoaderLocal(){

        protected Object initialValue() {
            return new BeanUtilsBean();
        }
    };
    private Log log = LogFactory.getLog(BeanUtils.class);
    private ConvertUtilsBean convertUtilsBean;
    private PropertyUtilsBean propertyUtilsBean;

    public static synchronized BeanUtilsBean getInstance() {
        return (BeanUtilsBean)beansByClassLoader.get();
    }

    public static synchronized void setInstance(BeanUtilsBean beanUtilsBean) {
        beansByClassLoader.set(beanUtilsBean);
    }

    public BeanUtilsBean() {
        this(new ConvertUtilsBean(), new PropertyUtilsBean());
    }

    public BeanUtilsBean(ConvertUtilsBean convertUtilsBean, PropertyUtilsBean propertyUtilsBean) {
        this.convertUtilsBean = convertUtilsBean;
        this.propertyUtilsBean = propertyUtilsBean;
    }

    public Object cloneBean(Object object) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cloning bean: " + object.getClass().getName());
        }
        object.getClass();
        DynaBean dynaBean = null;
        dynaBean = object instanceof DynaBean ? ((DynaBean)object).getDynaClass().newInstance() : (DynaBean)object.getClass().newInstance();
        this.getPropertyUtils().copyProperties(dynaBean, object);
        return dynaBean;
    }

    public void copyProperties(Object object, Object object2) throws IllegalAccessException, InvocationTargetException {
        if (object == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (object2 == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("BeanUtils.copyProperties(" + object + ", " + object2 + ")");
        }
        if (object2 instanceof DynaBean) {
            DynaProperty[] dynaPropertyArray = ((DynaBean)object2).getDynaClass().getDynaProperties();
            int n = 0;
            while (n < dynaPropertyArray.length) {
                String string = dynaPropertyArray[n].getName();
                if (this.getPropertyUtils().isWriteable(object, string)) {
                    Object object3 = ((DynaBean)object2).get(string);
                    this.copyProperty(object, string, object3);
                }
                ++n;
            }
        } else if (object2 instanceof Map) {
            for (String string : ((Map)object2).keySet()) {
                if (!this.getPropertyUtils().isWriteable(object, string)) continue;
                Object v = ((Map)object2).get(string);
                this.copyProperty(object, string, v);
            }
        } else {
            PropertyDescriptor[] propertyDescriptorArray = this.getPropertyUtils().getPropertyDescriptors(object2);
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                String string = propertyDescriptorArray[n].getName();
                if (!"class".equals(string) && this.getPropertyUtils().isReadable(object2, string) && this.getPropertyUtils().isWriteable(object, string)) {
                    try {
                        Object object4 = this.getPropertyUtils().getSimpleProperty(object2, string);
                        this.copyProperty(object, string, object4);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
                ++n;
            }
        }
    }

    public void copyProperty(Object object, String string, Object object2) throws IllegalAccessException, InvocationTargetException {
        Object object3;
        int n;
        Object object4;
        if (this.log.isTraceEnabled()) {
            object4 = new StringBuffer("  copyProperty(");
            ((StringBuffer)object4).append(object);
            ((StringBuffer)object4).append(", ");
            ((StringBuffer)object4).append(string);
            ((StringBuffer)object4).append(", ");
            if (object2 == null) {
                ((StringBuffer)object4).append("<NULL>");
            } else if (object2 instanceof String) {
                ((StringBuffer)object4).append((String)object2);
            } else if (object2 instanceof String[]) {
                String[] stringArray = (String[])object2;
                ((StringBuffer)object4).append('[');
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (n2 > 0) {
                        ((StringBuffer)object4).append(',');
                    }
                    ((StringBuffer)object4).append(stringArray[n2]);
                    ++n2;
                }
                ((StringBuffer)object4).append(']');
            } else {
                ((StringBuffer)object4).append(object2.toString());
            }
            ((StringBuffer)object4).append(')');
            this.log.trace(((StringBuffer)object4).toString());
        }
        object4 = object;
        int n3 = string.lastIndexOf(46);
        if (n3 >= 0) {
            try {
                object4 = this.getPropertyUtils().getProperty(object, string.substring(0, n3));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
            string = string.substring(n3 + 1);
            if (this.log.isTraceEnabled()) {
                this.log.trace("    Target bean = " + object4);
                this.log.trace("    Target name = " + string);
            }
        }
        String string2 = null;
        Class<?> clazz = null;
        int n4 = -1;
        String string3 = null;
        string2 = string;
        int n5 = string2.indexOf(91);
        if (n5 >= 0) {
            n = string2.indexOf(93);
            try {
                n4 = Integer.parseInt(string2.substring(n5 + 1, n));
            }
            catch (NumberFormatException numberFormatException) {}
            string2 = string2.substring(0, n5);
        }
        if ((n = string2.indexOf(40)) >= 0) {
            int n6 = string2.indexOf(41);
            try {
                string3 = string2.substring(n + 1, n6);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            string2 = string2.substring(0, n);
        }
        if (object4 instanceof DynaBean) {
            object3 = ((DynaBean)object4).getDynaClass();
            DynaProperty dynaProperty = object3.getDynaProperty(string2);
            if (dynaProperty == null) {
                return;
            }
            clazz = dynaProperty.getType();
        } else {
            object3 = null;
            try {
                object3 = this.getPropertyUtils().getPropertyDescriptor(object4, string);
                if (object3 == null) {
                    return;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
            clazz = ((PropertyDescriptor)object3).getPropertyType();
            if (clazz == null) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("    target type for property '" + string2 + "' is null, so skipping ths setter");
                }
                return;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("    target propName=" + string2 + ", type=" + clazz + ", index=" + n4 + ", key=" + string3);
        }
        if (n4 >= 0) {
            object3 = this.getConvertUtils().lookup(clazz.getComponentType());
            if (object3 != null) {
                this.log.trace("        USING CONVERTER " + object3);
                object2 = object3.convert(clazz, object2);
            }
            try {
                this.getPropertyUtils().setIndexedProperty(object4, string2, n4, object2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InvocationTargetException(noSuchMethodException, "Cannot set " + string2);
            }
        }
        if (string3 != null) {
            try {
                this.getPropertyUtils().setMappedProperty(object4, string2, string3, object2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new InvocationTargetException(noSuchMethodException, "Cannot set " + string2);
            }
        }
        object3 = this.getConvertUtils().lookup(clazz);
        if (object3 != null) {
            this.log.trace("        USING CONVERTER " + object3);
            object2 = object3.convert(clazz, object2);
        }
        try {
            this.getPropertyUtils().setSimpleProperty(object4, string2, object2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InvocationTargetException(noSuchMethodException, "Cannot set " + string2);
        }
    }

    public Map describe(Object object) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (object == null) {
            return new HashMap();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Describing bean: " + object.getClass().getName());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (object instanceof DynaBean) {
            DynaProperty[] dynaPropertyArray = ((DynaBean)object).getDynaClass().getDynaProperties();
            int n = 0;
            while (n < dynaPropertyArray.length) {
                String string = dynaPropertyArray[n].getName();
                hashMap.put(string, this.getProperty(object, string));
                ++n;
            }
        } else {
            PropertyDescriptor[] propertyDescriptorArray = this.getPropertyUtils().getPropertyDescriptors(object);
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                String string = propertyDescriptorArray[n].getName();
                if (propertyDescriptorArray[n].getReadMethod() != null) {
                    hashMap.put(string, this.getProperty(object, string));
                }
                ++n;
            }
        }
        return hashMap;
    }

    public String[] getArrayProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object2 = this.getPropertyUtils().getProperty(object, string);
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof Collection) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object e : (Collection)object2) {
                if (e == null) {
                    arrayList.add(null);
                    continue;
                }
                arrayList.add(this.getConvertUtils().convert(e));
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        if (object2.getClass().isArray()) {
            int n = Array.getLength(object2);
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                Object object3 = Array.get(object2, n2);
                stringArray[n2] = object3 == null ? null : this.getConvertUtils().convert(object3);
                ++n2;
            }
            return stringArray;
        }
        String[] stringArray = new String[]{object2.toString()};
        return stringArray;
    }

    public String getIndexedProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object2 = this.getPropertyUtils().getIndexedProperty(object, string);
        return this.getConvertUtils().convert(object2);
    }

    public String getIndexedProperty(Object object, String string, int n) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object2 = this.getPropertyUtils().getIndexedProperty(object, string, n);
        return this.getConvertUtils().convert(object2);
    }

    public String getMappedProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object2 = this.getPropertyUtils().getMappedProperty(object, string);
        return this.getConvertUtils().convert(object2);
    }

    public String getMappedProperty(Object object, String string, String string2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object2 = this.getPropertyUtils().getMappedProperty(object, string, string2);
        return this.getConvertUtils().convert(object2);
    }

    public String getNestedProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object2 = this.getPropertyUtils().getNestedProperty(object, string);
        return this.getConvertUtils().convert(object2);
    }

    public String getProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getNestedProperty(object, string);
    }

    public String getSimpleProperty(Object object, String string) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object2 = this.getPropertyUtils().getSimpleProperty(object, string);
        return this.getConvertUtils().convert(object2);
    }

    public void populate(Object object, Map map) throws IllegalAccessException, InvocationTargetException {
        if (object == null || map == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("BeanUtils.populate(" + object + ", " + map + ")");
        }
        for (String string : map.keySet()) {
            if (string == null) continue;
            Object v = map.get(string);
            this.setProperty(object, string, v);
        }
    }

    public void setProperty(Object object, String string, Object object2) throws IllegalAccessException, InvocationTargetException {
        String[] stringArray;
        Object object3;
        int n;
        Object object4;
        if (this.log.isTraceEnabled()) {
            object4 = new StringBuffer("  setProperty(");
            ((StringBuffer)object4).append(object);
            ((StringBuffer)object4).append(", ");
            ((StringBuffer)object4).append(string);
            ((StringBuffer)object4).append(", ");
            if (object2 == null) {
                ((StringBuffer)object4).append("<NULL>");
            } else if (object2 instanceof String) {
                ((StringBuffer)object4).append((String)object2);
            } else if (object2 instanceof String[]) {
                String[] stringArray2 = (String[])object2;
                ((StringBuffer)object4).append('[');
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    if (n2 > 0) {
                        ((StringBuffer)object4).append(',');
                    }
                    ((StringBuffer)object4).append(stringArray2[n2]);
                    ++n2;
                }
                ((StringBuffer)object4).append(']');
            } else {
                ((StringBuffer)object4).append(object2.toString());
            }
            ((StringBuffer)object4).append(')');
            this.log.trace(((StringBuffer)object4).toString());
        }
        object4 = object;
        int n3 = this.findLastNestedIndex(string);
        if (n3 >= 0) {
            try {
                object4 = this.getPropertyUtils().getProperty(object, string.substring(0, n3));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
            string = string.substring(n3 + 1);
            if (this.log.isTraceEnabled()) {
                this.log.trace("    Target bean = " + object4);
                this.log.trace("    Target name = " + string);
            }
        }
        String string2 = null;
        Class<?> clazz = null;
        int n4 = -1;
        String string3 = null;
        string2 = string;
        int n5 = string2.indexOf(91);
        if (n5 >= 0) {
            n = string2.indexOf(93);
            try {
                n4 = Integer.parseInt(string2.substring(n5 + 1, n));
            }
            catch (NumberFormatException numberFormatException) {}
            string2 = string2.substring(0, n5);
        }
        if ((n = string2.indexOf(40)) >= 0) {
            int n6 = string2.indexOf(41);
            try {
                string3 = string2.substring(n + 1, n6);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            string2 = string2.substring(0, n);
        }
        if (object4 instanceof DynaBean) {
            object3 = ((DynaBean)object4).getDynaClass();
            stringArray = object3.getDynaProperty(string2);
            if (stringArray == null) {
                return;
            }
            clazz = stringArray.getType();
        } else {
            object3 = null;
            try {
                object3 = this.getPropertyUtils().getPropertyDescriptor(object4, string);
                if (object3 == null) {
                    return;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return;
            }
            if (object3 instanceof MappedPropertyDescriptor) {
                if (((MappedPropertyDescriptor)object3).getMappedWriteMethod() == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Skipping read-only property");
                    }
                    return;
                }
                clazz = ((MappedPropertyDescriptor)object3).getMappedPropertyType();
            } else if (object3 instanceof IndexedPropertyDescriptor) {
                if (((IndexedPropertyDescriptor)object3).getIndexedWriteMethod() == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Skipping read-only property");
                    }
                    return;
                }
                clazz = ((IndexedPropertyDescriptor)object3).getIndexedPropertyType();
            } else {
                if (((PropertyDescriptor)object3).getWriteMethod() == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Skipping read-only property");
                    }
                    return;
                }
                clazz = ((PropertyDescriptor)object3).getPropertyType();
            }
        }
        object3 = null;
        if (clazz.isArray() && n4 < 0) {
            if (object2 == null) {
                stringArray = new String[]{(String)object2};
                object3 = this.getConvertUtils().convert(stringArray, clazz);
            } else if (object2 instanceof String) {
                stringArray = new String[]{(String)object2};
                object3 = this.getConvertUtils().convert(stringArray, clazz);
            } else {
                object3 = object2 instanceof String[] ? this.getConvertUtils().convert((String[])object2, clazz) : object2;
            }
        } else {
            object3 = clazz.isArray() ? (object2 instanceof String ? this.getConvertUtils().convert((String)object2, clazz.getComponentType()) : (object2 instanceof String[] ? this.getConvertUtils().convert(((String[])object2)[0], clazz.getComponentType()) : object2)) : (object2 instanceof String || object2 == null ? this.getConvertUtils().convert((String)object2, clazz) : (object2 instanceof String[] ? this.getConvertUtils().convert(((String[])object2)[0], clazz) : (this.getConvertUtils().lookup(object2.getClass()) != null ? this.getConvertUtils().convert(object2.toString(), clazz) : object2)));
        }
        try {
            if (n4 >= 0) {
                this.getPropertyUtils().setIndexedProperty(object4, string2, n4, object3);
            } else if (string3 != null) {
                this.getPropertyUtils().setMappedProperty(object4, string2, string3, object3);
            } else {
                this.getPropertyUtils().setProperty(object4, string2, object3);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InvocationTargetException(noSuchMethodException, "Cannot set " + string2);
        }
    }

    private int findLastNestedIndex(String string) {
        int n = 0;
        int n2 = string.length() - 1;
        while (n2 >= 0) {
            char c = string.charAt(n2);
            switch (c) {
                case '.': {
                    if (n >= 1) break;
                    return n2;
                }
                case '(': 
                case '[': {
                    --n;
                    break;
                }
                case ')': 
                case ']': {
                    ++n;
                }
            }
            --n2;
        }
        return -1;
    }

    public ConvertUtilsBean getConvertUtils() {
        return this.convertUtilsBean;
    }

    public PropertyUtilsBean getPropertyUtils() {
        return this.propertyUtilsBean;
    }
}

