/* RendPJTitular - Decompiled by JODE
 * Visit http://jode.sourceforge.net/
 */
package serpro.ppgd.irpf.rendpjexigibilidade;
import java.util.Iterator;
import java.util.List;

import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.Validador;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class RendPJComExigibilidadeTitular extends ObjetoNegocio
{
  public static final String NOME_NI_FONTE_PAGADORA = "NI da Fonte Pagadora";
  protected transient IdentificadorDeclaracao identificadorDeclaracao = null;
  protected Alfa nomeFontePagadora = new Alfa (this, "Nome da Fonte Pagadora");
  protected NI NIFontePagadora = new NI (this, "NI da Fonte Pagadora");
  protected Valor rendExigSuspensa = new Valor (this, "Rend. com Exigibilidade Suspensa");
  protected Valor depositoJudicial = new Valor (this, "Depósito Judicial");
  
  public RendPJComExigibilidadeTitular (IdentificadorDeclaracao id)
  {
    identificadorDeclaracao = id;
    addValidadores ();
  }
  
  public void addValidadores ()
  {
    ValidadorNaoNulo validadorNaoNuloNomeFontePagadora = new ValidadorNaoNulo ((byte) 3)
    {
      public RetornoValidacao validarImplementado ()
      {
	RetornoValidacao retornoValidacao = Validador.validarNI (getNIFontePagadora ().asString ());
	if (retornoValidacao == null && getNomeFontePagadora ().isVazio ())
	  {
	    setSeveridade ((byte) 2);
	    return new RetornoValidacao (tab.msg ("nome_fonte_pagadora_ausente"), (byte) 2);
	  }
	if (retornoValidacao != null && getNomeFontePagadora ().isVazio ())
	  {
	    setSeveridade ((byte) 3);
	    return new RetornoValidacao (tab.msg ("nome_fonte_pagadora"), (byte) 3);
	  }
	return null;
      }
    };
    getNomeFontePagadora ().addValidador (validadorNaoNuloNomeFontePagadora);
    ValidadorNaoNulo validadorNaoNuloNI = new ValidadorNaoNulo ((byte) 3)
    {
      public RetornoValidacao validarImplementado ()
      {
	RetornoValidacao retornoValidacao = Validador.validarNI (getNIFontePagadora ().asString ());
	if (getNIFontePagadora ().asString ().equals (identificadorDeclaracao.getCpf ().asString ()))
	  {
	    setSeveridade ((byte) 3);
	    return new RetornoValidacao (tab.msg ("ni_fonte_pagadora_igual_declarante"), (byte) 3);
	  }
	return null;
      }
    };
    getNIFontePagadora ().addValidador (validadorNaoNuloNI);
  }
  
  public void addObservador (Observador obs)
  {
    rendExigSuspensa.addObservador (obs);
    depositoJudicial.addObservador (obs);
    NIFontePagadora.addObservador (obs);
  }
  
  public void removeObservador (Observador obs)
  {
    rendExigSuspensa.removeObservador (obs);
    depositoJudicial.removeObservador (obs);
    NIFontePagadora.removeObservador (obs);
  }
  
  public Valor getDepositoJudicial ()
  {
    return depositoJudicial;
  }
  
  public NI getNIFontePagadora ()
  {
    return NIFontePagadora;
  }
  
  public Alfa getNomeFontePagadora ()
  {
    return nomeFontePagadora;
  }
  
  public Valor getRendExigSuspensa ()
  {
    return rendExigSuspensa;
  }
  
  public Pendencia verificaValores (int numItem)
  {
    Pendencia retorno = null;
    if (getDepositoJudicial ().isVazio () && getRendExigSuspensa ().isVazio ())
      retorno = new Pendencia ((byte) 2, getRendExigSuspensa (), "Valores RendPJ", tab.msg ("rendpj_faltam_valores"), numItem);
    return retorno;
  }
  
  public List verificarPendencias (int numeroItem)
  {
    List retorno = super.verificarPendencias (numeroItem);
    Pendencia pendValores = verificaValores (numeroItem);
    if (pendValores != null)
      retorno.add (pendValores);
    return retorno;
  }
  
  protected List recuperarListaCamposPendencia ()
  {
    List retorno = recuperarCamposInformacao ();
    return retorno;
  }
  
  public boolean isVazio ()
  {
    Iterator iterator = recuperarCamposInformacao ().iterator ();
    while (iterator.hasNext ())
      {
	Informacao informacao = (Informacao) iterator.next ();
	if (! informacao.isVazio ())
	  return false;
      }
    return true;
  }
}
