/* RendTributacaoExclusiva - Decompiled by JODE
 * Visit http://jode.sourceforge.net/
 */
package serpro.ppgd.irpf.rendTributacaoExclusiva;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.ColecaoItemQuadroAuxiliar;
import serpro.ppgd.irpf.ColecaoItemQuadroOutrosRendimentos;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class RendTributacaoExclusiva extends ObjetoNegocio
{
  private Valor decimoTerceiro = new Valor ();
  private Valor ganhosCapital = new Valor ();
  private Valor ganhosCapitalEstrangeira = new Valor ();
  private Valor ganhosCapitalEmEspecie = new Valor ();
  private Valor ganhosRendaVariavel = new Valor ();
  private Valor rendAplicacoes = new Valor ();
  private ColecaoItemQuadroOutrosRendimentos rendAplicacoesQuadroAuxiliar;
  private Valor rendPLR = new Valor ();
  private ColecaoItemQuadroOutrosRendimentos rendPLRQuadroAuxiliar;
  private ColecaoItemQuadroOutrosRendimentos outrosQuadroAuxiliar;
  private Valor decimoTerceiroDependentes = new Valor ();
  private Valor rendExcetoDecimoTerceiro = new Valor ();
  private ColecaoItemQuadroAuxiliar rendExcetoDecimoTerceiroQuadroAuxiliar = new ColecaoItemQuadroAuxiliar ();
  private Valor total = new Valor ();
  
  public RendTributacaoExclusiva (final DeclaracaoIRPF objDecl)
  {
    rendAplicacoesQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos
      (objDecl, "Rendimentos de Aplicações Financeiras");
    rendPLRQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos
      (objDecl, "Participação nos lucros e resultados");
    outrosQuadroAuxiliar = new ColecaoItemQuadroOutrosRendimentos
      (objDecl, "Outros rendimentos de tributação exclusiva na fonte");
    getDecimoTerceiro ().setReadOnly (true);
    getGanhosCapital ().setReadOnly (true);
    getGanhosCapitalEstrangeira ().setReadOnly (true);
    getGanhosCapitalEmEspecie ().setReadOnly (true);
    getGanhosRendaVariavel ().setReadOnly (true);
    getDecimoTerceiroDependentes ().setReadOnly (true);
    getTotal ().setReadOnly (true);
  }
  
  public void addObservador (Observador obs)
  {
    ganhosCapital.addObservador (obs);
    ganhosCapitalEstrangeira.addObservador (obs);
    ganhosCapitalEmEspecie.addObservador (obs);
    ganhosRendaVariavel.addObservador (obs);
    rendAplicacoes.addObservador (obs);
    rendPLR.addObservador (obs);
    outrosQuadroAuxiliar.addObservador (obs);
    decimoTerceiroDependentes.addObservador (obs);
    rendExcetoDecimoTerceiro.addObservador (obs);
  }
  
  public ColecaoItemQuadroOutrosRendimentos getRendPLRQuadroAuxiliar ()
  {
    return rendPLRQuadroAuxiliar;
  }
  
  public ColecaoItemQuadroOutrosRendimentos getOutrosQuadroAuxiliar ()
  {
    return outrosQuadroAuxiliar;
  }
  
  public ColecaoItemQuadroOutrosRendimentos getRendAplicacoesQuadroAuxiliar ()
  {
    return rendAplicacoesQuadroAuxiliar;
  }
  
  public ColecaoItemQuadroAuxiliar getRendExcetoDecimoTerceiroQuadroAuxiliar ()
  {
    return rendExcetoDecimoTerceiroQuadroAuxiliar;
  }
  
  public Valor getTotal ()
  {
    return total;
  }
  
  public void setTotal (Valor total)
  {
    this.total = total;
  }
  
  public Valor getDecimoTerceiro ()
  {
    return decimoTerceiro;
  }
  
  public void setDecimoTerceiro (Valor decimoTerceiro)
  {
    this.decimoTerceiro = decimoTerceiro;
  }
  
  public Valor getDecimoTerceiroDependentes ()
  {
    return decimoTerceiroDependentes;
  }
  
  public void setDecimoTerceiroDependentes (Valor decimoTerceiroDependentes)
  {
    this.decimoTerceiroDependentes = decimoTerceiroDependentes;
  }
  
  public Valor getGanhosCapital ()
  {
    return ganhosCapital;
  }
  
  public void setGanhosCapital (Valor ganhosCapital)
  {
    this.ganhosCapital = ganhosCapital;
  }
  
  public Valor getGanhosCapitalEmEspecie ()
  {
    return ganhosCapitalEmEspecie;
  }
  
  public void setGanhosCapitalEmEspecie (Valor ganhosCapitalEmEspecie)
  {
    this.ganhosCapitalEmEspecie = ganhosCapitalEmEspecie;
  }
  
  public Valor getGanhosCapitalEstrangeira ()
  {
    return ganhosCapitalEstrangeira;
  }
  
  public void setGanhosCapitalEstrangeira (Valor ganhosCapitalEstrangeira)
  {
    this.ganhosCapitalEstrangeira = ganhosCapitalEstrangeira;
  }
  
  public Valor getGanhosRendaVariavel ()
  {
    return ganhosRendaVariavel;
  }
  
  public void setGanhosRendaVariavel (Valor ganhosRendaVariavel)
  {
    this.ganhosRendaVariavel = ganhosRendaVariavel;
  }
  
  public Valor getOutros ()
  {
    return getOutrosQuadroAuxiliar ().getTotais ();
  }
  
  public Valor getRendAplicacoes ()
  {
    return rendAplicacoes;
  }
  
  public void setRendAplicacoes (Valor rendAplicacoes)
  {
    this.rendAplicacoes = rendAplicacoes;
  }
  
  public Valor getRendPLR ()
  {
    return rendPLR;
  }
  
  public void setRendPLR (Valor rendPLR)
  {
    this.rendPLR = rendPLR;
  }
  
  public Valor getRendExcetoDecimoTerceiro ()
  {
    return rendExcetoDecimoTerceiro;
  }
  
  public void setRendExcetoDecimoTerceiro (Valor rendExcetoDecimoTerceiro)
  {
    this.rendExcetoDecimoTerceiro = rendExcetoDecimoTerceiro;
  }
  
  public Valor recuperarExclusivosTitular ()
  {
    Valor result = new Valor ();
    result.append ('+', ganhosCapital);
    result.append ('+', ganhosCapitalEstrangeira);
    result.append ('+', ganhosCapitalEmEspecie);
    result.append ('+', decimoTerceiro);
    result.append ('+', rendAplicacoes);
    result.append ('+', rendPLR);
    result.append ('+', getOutros ());
    result.append ('+', ganhosRendaVariavel);
    return result;
  }
  
  public Valor recuperarExclusivosDependentes ()
  {
    return decimoTerceiroDependentes.operacao ('+', rendExcetoDecimoTerceiro);
  }
  
  public Valor recuperarTotalTitularExceto13_RV_e_GC ()
  {
    return getRendAplicacoes ().operacao ('+', getRendPLR ())
	.operacao ('+', getOutros ());
  }
}
