/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import serpro.ppgd.gui.ConstantesGlobaisGUI;
import serpro.ppgd.gui.editors.PPGDRadioButton;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.LogicoDefault;
import serpro.ppgd.gui.xbeans.PainelBotao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.OpcaoLogico;

public class JEditLogico
extends JEditCampo {
    private Box box;
    private ButtonGroup group;
    private int orientacaoTexto;
    private static final Color DEFAULT_FOREGROUND = new JRadioButton().getForeground();
    private static final Color DISABLED_FOREGROUND = ConstantesGlobaisGUI.COR_CINZA_CLARO;
    private boolean bloqueiaItemListener = false;
    private Map radios;
    private LinkedList listaOrdenada = new LinkedList();

    public JEditLogico() {
        this(new LogicoDefault());
    }

    public JEditLogico(Informacao informacao) {
        super(informacao);
        this.setOrientacaoTexto(1);
    }

    public void setFont(Font font) {
        for (JRadioButton jRadioButton : this.radios.values()) {
            jRadioButton.setFont(font);
        }
    }

    public void setForeground(Color color) {
        for (JRadioButton jRadioButton : this.radios.values()) {
            jRadioButton.setForeground(color);
        }
    }

    public void setFont(String string, Color color) {
        String string2 = ((Logico)this.getInformacao()).getLabelOpcao(string);
        if (this.radios.containsKey(string2)) {
            JRadioButton jRadioButton = (JRadioButton)this.radios.get(string2);
            jRadioButton.setForeground(color);
        }
    }

    public void setFont(String string, Font font) {
        String string2 = ((Logico)this.getInformacao()).getLabelOpcao(string);
        if (this.radios.containsKey(string2)) {
            JRadioButton jRadioButton = (JRadioButton)this.radios.get(string2);
            jRadioButton.setFont(font);
        }
    }

    public void addListener(String string, EventListener eventListener) {
        String string2 = ((Logico)this.getInformacao()).getLabelOpcao(string);
        if (this.radios.containsKey(string2)) {
            JRadioButton jRadioButton = (JRadioButton)this.radios.get(string2);
            this.adicionaListener(jRadioButton, eventListener);
        }
    }

    private void adicionaListener(JRadioButton jRadioButton, EventListener eventListener) {
        if (eventListener instanceof ActionListener) {
            jRadioButton.addActionListener((ActionListener)eventListener);
        } else if (eventListener instanceof ItemListener) {
            jRadioButton.addItemListener((ItemListener)eventListener);
        } else if (eventListener instanceof KeyListener) {
            jRadioButton.addKeyListener((KeyListener)eventListener);
        } else if (eventListener instanceof FocusListener) {
            jRadioButton.addFocusListener((FocusListener)eventListener);
        } else if (eventListener instanceof MouseListener) {
            jRadioButton.addMouseListener((MouseListener)eventListener);
        } else if (eventListener instanceof MouseMotionListener) {
            jRadioButton.addMouseMotionListener((MouseMotionListener)eventListener);
        }
    }

    public void addListener(EventListener eventListener) {
        for (JRadioButton jRadioButton : this.radios.values()) {
            this.adicionaListener(jRadioButton, eventListener);
        }
    }

    public int getOrientacaoTexto() {
        return this.orientacaoTexto;
    }

    public void setOrientacaoTexto(int n) {
        this.orientacaoTexto = n;
        this.buildComponente();
    }

    public void setOpcaoHabilitada(String string, boolean bl) {
        String string2 = ((Logico)this.getInformacao()).getLabelOpcao(string);
        if (this.radios.containsKey(string2)) {
            JRadioButton jRadioButton = (JRadioButton)this.radios.get(string2);
            jRadioButton.setEnabled(bl);
            if (!bl) {
                jRadioButton.setForeground(DISABLED_FOREGROUND);
            } else {
                jRadioButton.setForeground(DEFAULT_FOREGROUND);
            }
        }
    }

    public JComponent getComponenteEditor() {
        return this.box;
    }

    public void implementacaoPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setObservadorAtivo(false);
        if ((propertyChangeEvent.getPropertyName() == null || !propertyChangeEvent.getPropertyName().equals("ReadOnly")) && propertyChangeEvent.getNewValue() instanceof String) {
            String string = (String)propertyChangeEvent.getNewValue();
            if (string == null) {
                string = "";
            }
            if (string.equals("")) {
                this.group.setSelected(new JRadioButton().getModel(), true);
            } else {
                String string2 = ((Logico)this.getInformacao()).getLabelOpcao(string);
                for (JRadioButton jRadioButton : this.radios.values()) {
                    if (jRadioButton.getText().equals(string2)) {
                        this.setBloqueiaItemListener(true);
                        jRadioButton.setSelected(true);
                        this.setBloqueiaItemListener(false);
                        continue;
                    }
                    this.setBloqueiaItemListener(true);
                    jRadioButton.setSelected(false);
                    this.setBloqueiaItemListener(false);
                }
            }
        }
        this.setObservadorAtivo(true);
    }

    protected void readOnlyPropertyChange(boolean bl) {
        for (JRadioButton jRadioButton : this.radios.values()) {
            jRadioButton.setEnabled(!bl);
        }
    }

    protected void habilitadoPropertyChange(boolean bl) {
        for (JRadioButton jRadioButton : this.radios.values()) {
            jRadioButton.setEnabled(bl);
        }
    }

    public JComponent getComponenteFoco() {
        if (this.radios.values().size() > 0) {
            return (JRadioButton)this.radios.values().toArray()[0];
        }
        return null;
    }

    public Map getRadios() {
        return this.radios;
    }

    public void setRadios(Map map) {
        this.radios = map;
    }

    public LinkedList getListaRadiosOrdenada() {
        return this.listaOrdenada;
    }

    public boolean isBloqueiaItemListener() {
        return this.bloqueiaItemListener;
    }

    public void setBloqueiaItemListener(boolean bl) {
        this.bloqueiaItemListener = bl;
    }

    protected void buildComponente() {
        Object object;
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.radios = new Hashtable();
        this.listaOrdenada = new LinkedList();
        this.box = new Box(this.getOrientacaoTexto());
        Logico logico = (Logico)this.getInformacao();
        this.group = new ButtonGroup();
        if (logico != null) {
            Object object2;
            object = logico.getListaOrdenada().iterator();
            while (object.hasNext()) {
                object2 = (OpcaoLogico)object.next();
                PPGDRadioButton pPGDRadioButton = new PPGDRadioButton(((OpcaoLogico)object2).labelOpcao, ((OpcaoLogico)object2).selecionado);
                pPGDRadioButton.setInformacao(this.campo);
                pPGDRadioButton.setVisible(true);
                this.radios.put(pPGDRadioButton.getText(), pPGDRadioButton);
                this.listaOrdenada.addLast(pPGDRadioButton);
                pPGDRadioButton.addFocusListener(new FocusAdapter(){

                    public void focusGained(FocusEvent focusEvent) {
                    }

                    public void focusLost(FocusEvent focusEvent) {
                        if (focusEvent.getOppositeComponent() != null) {
                            JEditLogico.this.setIdentificacaoFoco(false);
                            JEditLogico.this.chamaValidacao();
                        }
                    }
                });
                pPGDRadioButton.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (itemEvent.getStateChange() == 1 && !JEditLogico.this.isBloqueiaItemListener()) {
                            System.out.println("id evento->" + itemEvent.getID());
                            JRadioButton jRadioButton = (JRadioButton)itemEvent.getSource();
                            String string = jRadioButton.getText().trim();
                            String string2 = ((Logico)JEditLogico.this.getInformacao()).getValorOpcao(string);
                            ((Logico)JEditLogico.this.getInformacao()).atualizaListaValidadoresImpeditivos(string2);
                            if (JEditLogico.this.getInformacao().getListaValidadoresImpeditivos().isEmpty() || JEditLogico.this.verificaValidacoesImpeditivas(string2)) {
                                ((Logico)JEditLogico.this.getInformacao()).setConteudo(string2);
                            }
                        }
                    }
                });
                if (this.getOrientacaoTexto() == 0) {
                    this.box.add(new JLabel(" "));
                }
                this.box.add(pPGDRadioButton);
                if (!((Logico)this.campo).isSelecaoMultipla()) {
                    this.group.add(pPGDRadioButton);
                }
                if (object.hasNext() || this.getOrientacaoTexto() != 0) continue;
                this.box.add(new JLabel(" "));
            }
            this.setObservadorAtivo(false);
            object2 = new PropertyChangeEvent(this, null, null, this.getInformacao().asString());
            this.implementacaoPropertyChange((PropertyChangeEvent)object2);
            this.setObservadorAtivo(true);
        }
        this.add((Component)this.box, "Center");
        object = this.getButtonMensagem();
        if (object != null) {
            this.add((Component)new PainelBotao((JButtonMensagem)object), "East");
        }
    }

    protected void informacaoModificada() {
        this.buildComponente();
    }

    public void setEstiloFonte(int n) {
        JRadioButton jRadioButton = null;
        jRadioButton = !this.radios.isEmpty() ? (JRadioButton)this.radios.values().toArray()[0] : new JRadioButton();
        Font font = jRadioButton.getFont();
        font = font.deriveFont(n);
        this.setFont(font);
    }

    public void setIncrementoTamanhoFonte(int n) {
        this.incrementoTamanhoFonte = n;
        JRadioButton jRadioButton = null;
        jRadioButton = !this.radios.isEmpty() ? (JRadioButton)this.radios.values().toArray()[0] : new JRadioButton();
        Font font = jRadioButton.getFont();
        if (this.tamanhoOriginal == -1.0f) {
            this.tamanhoOriginal = font.getSize2D();
        }
        font = font.deriveFont(this.tamanhoOriginal + (float)n);
        this.setFont(font);
    }

    public int getIncrementoTamanhoFonte() {
        return this.incrementoTamanhoFonte;
    }
}

