/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSEnvelopedGenerator;

class CMSEnvelopedHelper {
    static final CMSEnvelopedHelper INSTANCE = new CMSEnvelopedHelper();
    private static final Map KEYSIZES = new HashMap();
    private static final Map CIPHERS = new HashMap();

    static {
        KEYSIZES.put(CMSEnvelopedGenerator.DES_EDE3_CBC, new Integer(192));
        KEYSIZES.put(CMSEnvelopedGenerator.AES128_CBC, new Integer(128));
        KEYSIZES.put(CMSEnvelopedGenerator.AES192_CBC, new Integer(192));
        KEYSIZES.put(CMSEnvelopedGenerator.AES256_CBC, new Integer(256));
        CIPHERS.put(CMSEnvelopedGenerator.DES_EDE3_CBC, "DESEDE");
        CIPHERS.put(CMSEnvelopedGenerator.AES128_CBC, "AES");
        CIPHERS.put(CMSEnvelopedGenerator.AES192_CBC, "AES");
        CIPHERS.put(CMSEnvelopedGenerator.AES256_CBC, "AES");
    }

    CMSEnvelopedHelper() {
    }

    private String getEncryptionAlgName(String string) {
        if (PKCSObjectIdentifiers.rsaEncryption.getId().equals(string)) {
            return "RSA/ECB/PKCS1Padding";
        }
        return string;
    }

    Cipher createAsymmetricCipher(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        try {
            return Cipher.getInstance(string, string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return Cipher.getInstance(this.getEncryptionAlgName(string), string2);
        }
    }

    KeyGenerator createKeyGenerator(String string, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        KeyGenerator keyGenerator;
        try {
            keyGenerator = KeyGenerator.getInstance(string, string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            keyGenerator = KeyGenerator.getInstance(string);
        }
        return keyGenerator;
    }

    String getRFC3211WrapperName(String string) {
        String string2 = (String)CIPHERS.get(string);
        if (string2 == null) {
            throw new IllegalArgumentException("no name for " + string);
        }
        return String.valueOf(string2) + "RFC3211Wrap";
    }

    int getKeySize(String string) {
        Integer n = (Integer)KEYSIZES.get(string);
        if (n == null) {
            throw new IllegalArgumentException("no keysize for " + string);
        }
        return n;
    }
}

