/* CalculosRendPJDependentes - Decompiled by JODE
 * Visit http://jode.sourceforge.net/
 */
package serpro.ppgd.irpf.calculos;
import java.util.Hashtable;
import java.util.Iterator;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendpjexigibilidade.ColecaoRendPJComExigibilidadeDependente;
import serpro.ppgd.irpf.rendpjexigibilidade.RendPJComExigibilidadeDependente;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosRendPJComExigibilidadeDependentes extends Observador
{
  private ColecaoRendPJComExigibilidadeDependente colecaoRendPJ = null;
  private DeclaracaoIRPF declaracaoIRPF;
  
  public CalculosRendPJComExigibilidadeDependentes (ColecaoRendPJComExigibilidadeDependente colecao, DeclaracaoIRPF dec)
  {
    colecaoRendPJ = colecao;
    declaracaoIRPF = dec;
  }
  
  public void notifica (Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo)
  {
    if (nomePropriedade != null)
      {
	if (nomePropriedade.equals ("ObjetoInserido"))
	  {
	    RendPJComExigibilidadeDependente rendPJ = (RendPJComExigibilidadeDependente) valorNovo;
	    rendPJ.addObservador (this);
	    calculaTotaisRendExigSuspensa ();
	    calculaTotaisDepositoJudicial ();
	  }
	else if (nomePropriedade.equals ("ObjetoRemovido"))
	  {
	    RendPJComExigibilidadeDependente rendPJ = (RendPJComExigibilidadeDependente) valorNovo;
	    rendPJ.removeObservador (this);
	    calculaTotaisRendExigSuspensa ();
	    calculaTotaisDepositoJudicial ();
	  }
	else if (nomePropriedade.equals ("Rend. com Exigibilidade Suspensa"))
	  calculaTotaisRendExigSuspensa ();
	else if (nomePropriedade.equals ("Depósito Judicial"))
	  calculaTotaisDepositoJudicial ();
      }
  }
  
  private void calculaTotaisDepositoJudicial ()
  {
    Valor total = new Valor ();
    Iterator itRend = colecaoRendPJ.recuperarLista ().iterator ();
    while (itRend.hasNext ())
      {
	RendPJComExigibilidadeDependente rendAtual = (RendPJComExigibilidadeDependente) itRend.next ();
	total.append ('+', rendAtual.getDepositoJudicial ());
      }
    colecaoRendPJ.getTotaisDepositoJudicial ().setConteudo (total);
  }
  
  private void calculaTotaisRendExigSuspensa ()
  {
    Valor total = new Valor ();
    Iterator itRend = colecaoRendPJ.recuperarLista ().iterator ();
    while (itRend.hasNext ())
      {
	RendPJComExigibilidadeDependente rendAtual = (RendPJComExigibilidadeDependente) itRend.next ();
	total.append ('+', rendAtual.getRendExigSuspensa ());
      }
    colecaoRendPJ.getTotaisRendRecebidoPJ ().setConteudo (total);
  }
}
